'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ColumnSelectorListItem = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _class2; /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                      * You may use and modify this code under the terms of the Kuali, Inc.
                      * Pre-Release License Agreement. You may not distribute it.
                      *
                      * You should have received a copy of the Kuali, Inc. Pre-Release License
                      * Agreement with this file. If not, please write to license@kuali.co.
                      */

// eslint-disable-next-line import/named


var _clone = require('lodash/clone');

var _clone2 = _interopRequireDefault(_clone);

var _without = require('lodash/without');

var _without2 = _interopRequireDefault(_without);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _ = require('../../..');

var _heading = require('../heading');

var _heading2 = _interopRequireDefault(_heading);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var ColumnSelectorListItem = exports.ColumnSelectorListItem = (0, _coreDecorators.autobind)(_class = function (_PureComponent) {
  _inherits(ColumnSelectorListItem, _PureComponent);

  function ColumnSelectorListItem() {
    _classCallCheck(this, ColumnSelectorListItem);

    return _possibleConstructorReturn(this, (ColumnSelectorListItem.__proto__ || Object.getPrototypeOf(ColumnSelectorListItem)).apply(this, arguments));
  }

  _createClass(ColumnSelectorListItem, [{
    key: 'handleClick',
    value: function handleClick(evt) {
      var _props = this.props,
          column = _props.column,
          active = _props.active;

      this.props.onToggle(column.name, !active, evt);
    }
  }, {
    key: 'render',
    value: function render() {
      var _props2 = this.props,
          column = _props2.column,
          className = _props2.className,
          active = _props2.active,
          rest = _objectWithoutProperties(_props2, ['column', 'className', 'active']);

      var classes = (0, _classnames2.default)('', className);

      var variant = active ? 'info' : 'default';
      var rightIcon = _react2.default.createElement(_.Icon, { name: 'remove_red_eye', variant: variant });

      delete rest.onToggle;

      return _react2.default.createElement(_.ListItem, _extends({
        className: classes,
        onClick: this.handleClick,
        primaryText: column.label,
        rightIcon: rightIcon
      }, rest));
    }
  }]);

  return ColumnSelectorListItem;
}(_react.PureComponent)) || _class;

ColumnSelectorListItem.defaultProps = {
  className: '',
  active: false
};
ColumnSelectorListItem.propTypes = {
  className: _propTypes2.default.string,
  column: _propTypes2.default.shape({
    label: _propTypes2.default.string.isRequired,
    name: _propTypes2.default.string.isRequired
  }),
  onToggle: _propTypes2.default.func.isRequired,
  active: _propTypes2.default.bool.isRequired
};

var ColumnSelector = (0, _coreDecorators.autobind)(_class2 = function (_Component) {
  _inherits(ColumnSelector, _Component);

  function ColumnSelector() {
    var _ref;

    var _temp, _this2, _ret;

    _classCallCheck(this, ColumnSelector);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this2 = _possibleConstructorReturn(this, (_ref = ColumnSelector.__proto__ || Object.getPrototypeOf(ColumnSelector)).call.apply(_ref, [this].concat(args))), _this2), _this2.state = {
      visible: false
    }, _temp), _possibleConstructorReturn(_this2, _ret);
  }

  _createClass(ColumnSelector, [{
    key: 'handleReset',
    value: function handleReset(evt) {
      var _props3 = this.props,
          filter = _props3.filter,
          onChange = _props3.onChange;


      onChange(_extends({}, filter, { columns: [] }));
    }
  }, {
    key: 'handleColumnToggle',
    value: function handleColumnToggle(columnName, toInclude, evt) {
      var defaultColumns = this.defaultColumns;
      var _props4 = this.props,
          filter = _props4.filter,
          onChange = _props4.onChange;


      var columns = this.hasSelectedColumns() ? (0, _clone2.default)(filter.columns) : defaultColumns;

      if (toInclude) {
        columns.push(columnName);
      } else {
        columns = (0, _without2.default)(columns, columnName);
      }

      onChange(_extends({}, filter, { columns: columns }));
    }
  }, {
    key: 'handleClose',
    value: function handleClose(evt) {
      this.setState({ visible: false });
    }
  }, {
    key: 'handleOpen',
    value: function handleOpen(evt) {
      this.setState({ visible: true });
    }
  }, {
    key: 'handleToggle',
    value: function handleToggle(evt) {
      this.setState({ visible: !this.state.visible });
    }
  }, {
    key: 'hasSelectedColumns',
    value: function hasSelectedColumns() {
      var columns = this.props.filter.columns;

      return !!columns && columns.length > 0;
    }
  }, {
    key: 'isActiveColumn',
    value: function isActiveColumn(col) {
      var defaultColumns = this.defaultColumns;
      var filter = this.props.filter;

      var haystack = this.hasSelectedColumns() ? filter.columns : defaultColumns;

      return haystack.includes(col.name);
    }
  }, {
    key: 'render',
    value: function render() {
      var _this3 = this;

      var visible = this.state.visible;
      var _props5 = this.props,
          className = _props5.className,
          columns = _props5.columns,
          selectedColumns = _props5.filter.columns;


      var classes = (0, _classnames2.default)('filter-editor__column-selector', className);

      var hasSelectedColumns = this.hasSelectedColumns();

      var toggleButton = _react2.default.createElement(
        _.RaisedButton,
        { label: 'Choose Columns', onClick: this.handleToggle },
        _react2.default.createElement(_.Icon, { name: 'remove_red_eye', variant: 'info' })
      );

      var metaText = hasSelectedColumns ? selectedColumns.length + '/' + columns.length + ' columns selected' : 'standard columns selected';

      return _react2.default.createElement(
        'div',
        { className: classes },
        _react2.default.createElement(
          'div',
          { className: 'filter-editor__column-selector--title' },
          _react2.default.createElement(
            _heading2.default,
            { className: 'filter-editor__title' },
            'Table Column Visibility'
          ),
          hasSelectedColumns ? _react2.default.createElement(
            _.RaisedButton,
            { label: 'Reset', onClick: this.handleReset, size: 'small' },
            _react2.default.createElement(_.Icon, { name: 'settings_backup_restore', variant: 'error' })
          ) : null
        ),
        _react2.default.createElement(
          'div',
          { className: 'filter-editor__column-selector--body' },
          _react2.default.createElement(
            _.Menu,
            {
              id: 'column-selector-menu',
              sameWidth: false,
              visible: visible,
              onClose: this.handleClose,
              position: _.Menu.Positions.BELOW,
              toggle: toggleButton
            },
            columns.map(function (col) {
              return _react2.default.createElement(ColumnSelectorListItem, {
                column: col,
                key: col.name,
                onToggle: _this3.handleColumnToggle,
                active: _this3.isActiveColumn(col)
              });
            })
          ),
          _react2.default.createElement(
            'p',
            { className: 'filter-editor__column-selector--meta' },
            metaText
          )
        )
      );
    }
  }, {
    key: 'defaultColumns',
    get: function get() {
      var availableColumns = this.props.columns;


      return availableColumns.filter(function (_ref2) {
        var isDefault = _ref2.isDefault;
        return isDefault;
      }).map(function (_ref3) {
        var name = _ref3.name;
        return name;
      });
    }
  }]);

  return ColumnSelector;
}(_react.Component)) || _class2;

ColumnSelector.defaultProps = {
  className: ''
};
ColumnSelector.propTypes = {
  className: _propTypes2.default.string.isRequired,
  columns: _propTypes2.default.arrayOf(_propTypes2.default.shape({
    label: _propTypes2.default.string.isRequired,
    isDefault: _propTypes2.default.bool.isRequired,
    name: _propTypes2.default.string.isRequired
  })).isRequired,
  filter: _propTypes2.default.shape({
    columns: _propTypes2.default.arrayOf(_propTypes2.default.string)
  }),
  onChange: _propTypes2.default.func.isRequired
};
exports.default = ColumnSelector;