'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _constants = require('../../constants');

var _selectFieldButton = require('../select-field-button');

var _selectFieldButton2 = _interopRequireDefault(_selectFieldButton);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var valueTypes = [_constants.OPERATION_TYPES.AND, _constants.OPERATION_TYPES.OR];

var Operation = function (_PureComponent) {
  _inherits(Operation, _PureComponent);

  function Operation() {
    _classCallCheck(this, Operation);

    return _possibleConstructorReturn(this, (Operation.__proto__ || Object.getPrototypeOf(Operation)).apply(this, arguments));
  }

  _createClass(Operation, [{
    key: 'render',
    value: function render() {
      var shouldRenderSelector = this.props.rowIndex === 1;
      return shouldRenderSelector ? this.selector : this.label;
    }
  }, {
    key: 'classes',
    get: function get() {
      return (0, _classnames2.default)('filter-editor__operation', this.props.className);
    }
  }, {
    key: 'label',
    get: function get() {
      var _props = this.props,
          rowIndex = _props.rowIndex,
          value = _props.value;


      var label = rowIndex === 0 ? 'Where' : value;
      var labelClasses = (0, _classnames2.default)('filter-editor__operation__label', this.classes);

      return _react2.default.createElement(
        'span',
        { className: labelClasses },
        label
      );
    }
  }, {
    key: 'selector',
    get: function get() {
      var _props2 = this.props,
          onChange = _props2.onChange,
          value = _props2.value;


      return _react2.default.createElement(_selectFieldButton2.default, {
        className: this.classes,
        id: 'operation selector',
        menuItems: valueTypes,
        value: value,
        onChange: onChange
      });
    }
  }]);

  return Operation;
}(_react.PureComponent);

Operation.defaultProps = {
  className: ''
};
Operation.propTypes = {
  className: _propTypes2.default.string,
  rowIndex: _propTypes2.default.number.isRequired,
  onChange: _propTypes2.default.func.isRequired,
  value: _propTypes2.default.oneOf(valueTypes)
};
Operation.defaultProps = {
  value: _constants.OPERATION_TYPES.AND
};
exports.default = Operation;