'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class; /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
             * You may use and modify this code under the terms of the Kuali, Inc.
             * Pre-Release License Agreement. You may not distribute it.
             *
             * You should have received a copy of the Kuali, Inc. Pre-Release License
             * Agreement with this file. If not, please write to license@kuali.co.
             */

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _textFieldCustom = require('../text-field-custom');

var _textFieldCustom2 = _interopRequireDefault(_textFieldCustom);

var _constants = require('../../constants');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var TimeField = (0, _coreDecorators.autobind)(_class = function (_PureComponent) {
  _inherits(TimeField, _PureComponent);

  function TimeField() {
    _classCallCheck(this, TimeField);

    return _possibleConstructorReturn(this, (TimeField.__proto__ || Object.getPrototypeOf(TimeField)).apply(this, arguments));
  }

  _createClass(TimeField, [{
    key: 'handleTimeChange',
    value: function handleTimeChange(value) {
      return {
        time: (0, _constants.getSecondsFromString)(value)
      };
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          className = _props.className,
          _onChange = _props.onChange,
          value = _props.value,
          rest = _objectWithoutProperties(_props, ['className', 'onChange', 'value']);

      var classes = (0, _classnames2.default)('filter-editor__time-field', className);

      return _react2.default.createElement(_textFieldCustom2.default, _extends({
        className: classes,
        onChange: function onChange(value) {
          return _onChange(_this2.handleTimeChange(value));
        },
        type: 'time',
        value: this.time
      }, rest));
    }
  }, {
    key: 'time',
    get: function get() {
      var propValue = this.props.value;

      if (!propValue) return '';

      var seconds = typeof propValue === 'string' ? (0, _constants.getSecondsFromString)(propValue) : propValue.time;
      var date = new Date((0, _constants.getStartOfDay)().getTime() + seconds * 1000);
      return date.toLocaleString({}, { hour: 'numeric', minute: 'numeric', hour12: false });
    }
  }]);

  return TimeField;
}(_react.PureComponent)) || _class;

TimeField.defaultProps = {
  className: ''
};
TimeField.propTypes = {
  id: _propTypes2.default.string.isRequired,
  className: _propTypes2.default.string,
  onChange: _propTypes2.default.func.isRequired,
  value: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.shape({
    time: _propTypes2.default.oneOfType([_propTypes2.default.number, _propTypes2.default.string])
  })])
};
exports.default = TimeField;