'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class; /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
             * You may use and modify this code under the terms of the Kuali, Inc.
             * Pre-Release License Agreement. You may not distribute it.
             *
             * You should have received a copy of the Kuali, Inc. Pre-Release License
             * Agreement with this file. If not, please write to license@kuali.co.
             */

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _ = require('../..');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var StandardLayout = (0, _coreDecorators.autobind)(_class = function (_Component) {
  _inherits(StandardLayout, _Component);

  function StandardLayout() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, StandardLayout);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = StandardLayout.__proto__ || Object.getPrototypeOf(StandardLayout)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
      navCollapsed: false,
      navOverlayed: false
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(StandardLayout, [{
    key: 'toggleNavCollapse',
    value: function toggleNavCollapse(evt) {
      this.setState({ navCollapsed: !this.state.navCollapsed });
    }
  }, {
    key: 'toggleNavOverlay',
    value: function toggleNavOverlay(evt) {
      this.setState({ navOverlayed: !this.state.navOverlayed });
    }
  }, {
    key: 'renderNavList',
    value: function renderNavList() {
      if (!this.props.navList) {
        return null;
      }

      var _state = this.state,
          navCollapsed = _state.navCollapsed,
          navOverlayed = _state.navOverlayed;

      var navClasses = (0, _classnames2.default)('layout__nav', {
        'layout__nav--collapsed': navCollapsed,
        'layout__nav--overlayed': navOverlayed
      });

      return _react2.default.createElement(
        'nav',
        { className: navClasses },
        _react2.default.createElement(
          _.NavList,
          null,
          _react2.default.createElement(
            _.NavListItem,
            {
              className: 'nav-list__item--hide',
              iconName: navCollapsed ? 'menu' : 'clear',
              onClick: this.toggleNavCollapse
            },
            'Hide Menu'
          )
        ),
        this.props.navList,
        _react2.default.createElement(
          _.FlatButton,
          {
            className: 'layout__nav-close',
            onClick: this.toggleNavOverlay,
            variant: 'clear'
          },
          _react2.default.createElement(_.Icon, { name: 'close' })
        )
      );
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          children = _props.children,
          className = _props.className,
          header = _props.header,
          navList = _props.navList,
          sidebar = _props.sidebar,
          titleBar = _props.titleBar;


      var classes = (0, _classnames2.default)('layout', 'layout--standard', className);

      return _react2.default.createElement(
        'div',
        { className: classes },
        header,
        _react2.default.createElement(
          'div',
          { className: 'layout__body' },
          this.renderNavList(),
          _react2.default.createElement(
            'main',
            { className: 'layout__main' },
            _react2.default.cloneElement(titleBar, {
              hasNav: !!navList,
              onToggleNavOverlay: this.toggleNavOverlay
            }),
            _react2.default.createElement(
              'div',
              { className: 'layout__content-wrapper' },
              _react2.default.createElement(
                'div',
                { className: 'layout__content' },
                children
              ),
              sidebar ? _react2.default.cloneElement(sidebar, { className: 'layout__sidebar' }) : null
            )
          )
        )
      );
    }
  }]);

  return StandardLayout;
}(_react.Component)) || _class;

StandardLayout.propTypes = {
  children: _propTypes2.default.node.isRequired,
  className: _propTypes2.default.string,
  header: _propTypes2.default.element.isRequired,
  navList: _propTypes2.default.element,
  sidebar: _propTypes2.default.element,
  titleBar: _propTypes2.default.element.isRequired
};
exports.default = StandardLayout;