'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.NavButton = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class; /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
             * You may use and modify this code under the terms of the Kuali, Inc.
             * Pre-Release License Agreement. You may not distribute it.
             *
             * You should have received a copy of the Kuali, Inc. Pre-Release License
             * Agreement with this file. If not, please write to license@kuali.co.
             */

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _Inks = require('react-md/lib/Inks');

var _Inks2 = _interopRequireDefault(_Inks);

var _ = require('../../');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var NavButton = exports.NavButton = (0, _Inks2.default)(_class = function (_PureComponent) {
  _inherits(NavButton, _PureComponent);

  function NavButton() {
    _classCallCheck(this, NavButton);

    return _possibleConstructorReturn(this, (NavButton.__proto__ || Object.getPrototypeOf(NavButton)).apply(this, arguments));
  }

  _createClass(NavButton, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          children = _props.children,
          ink = _props.ink,
          rest = _objectWithoutProperties(_props, ['children', 'ink']);

      return _react2.default.createElement(
        'button',
        _extends({ className: 'title-bar__nav-button' }, rest),
        ink,
        children
      );
    }
  }]);

  return NavButton;
}(_react.PureComponent)) || _class;

NavButton.propTypes = {
  children: _propTypes2.default.node.isRequired,
  ink: _propTypes2.default.node
};

var TitleBar = function (_PureComponent2) {
  _inherits(TitleBar, _PureComponent2);

  function TitleBar() {
    _classCallCheck(this, TitleBar);

    return _possibleConstructorReturn(this, (TitleBar.__proto__ || Object.getPrototypeOf(TitleBar)).apply(this, arguments));
  }

  _createClass(TitleBar, [{
    key: 'render',
    value: function render() {
      var _props2 = this.props,
          children = _props2.children,
          className = _props2.className,
          hasNav = _props2.hasNav,
          onBack = _props2.onBack,
          onToggleNavOverlay = _props2.onToggleNavOverlay,
          rest = _objectWithoutProperties(_props2, ['children', 'className', 'hasNav', 'onBack', 'onToggleNavOverlay']);

      var classes = (0, _classnames2.default)('title-bar', { 'title-bar--withNav': hasNav }, className);

      return _react2.default.createElement(
        'div',
        _extends({ className: classes }, rest),
        hasNav ? _react2.default.createElement(
          NavButton,
          { onClick: onToggleNavOverlay },
          _react2.default.createElement(_.Icon, { name: 'menu' })
        ) : null,
        _react2.default.createElement(
          'div',
          { className: 'title-bar__inner' },
          _react2.default.createElement(
            'h1',
            { className: 'title-bar__heading' },
            children
          ),
          onBack ? _react2.default.createElement(
            _.RaisedButton,
            {
              className: 'title-bar__button-back',
              size: 'small',
              label: 'Back',
              onClick: onBack
            },
            _react2.default.createElement(_.Icon, { name: 'arrow_back' })
          ) : null
        )
      );
    }
  }]);

  return TitleBar;
}(_react.PureComponent);

TitleBar.propTypes = {
  children: _propTypes2.default.node.isRequired,
  className: _propTypes2.default.string,
  hasNav: _propTypes2.default.bool,
  onToggleNavOverlay: _propTypes2.default.func,
  onBack: _propTypes2.default.func
};
exports.default = TitleBar;