'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class; /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
             * You may use and modify this code under the terms of the Kuali, Inc.
             * Pre-Release License Agreement. You may not distribute it.
             *
             * You should have received a copy of the Kuali, Inc. Pre-Release License
             * Agreement with this file. If not, please write to license@kuali.co.
             */

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _buttons = require('../buttons');

var _buttons2 = _interopRequireDefault(_buttons);

var _ = require('..');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// eslint-disable-line import/named

var MenuButton = (0, _coreDecorators.autobind)(_class = function (_PureComponent) {
  _inherits(MenuButton, _PureComponent);

  function MenuButton(props) {
    _classCallCheck(this, MenuButton);

    var _this = _possibleConstructorReturn(this, (MenuButton.__proto__ || Object.getPrototypeOf(MenuButton)).call(this, props));

    _this.state = { visible: props.defaultOpen || false };
    return _this;
  }

  _createClass(MenuButton, [{
    key: '_toggleMenu',
    value: function _toggleMenu(e) {
      var visible = !this.state.visible;

      if (this.props.onClick) this.props.onClick(e);
      if (this.props.onMenuToggle) this.props.onMenuToggle(visible, e);

      this.setState({ visible: visible });
    }
  }, {
    key: '_closeMenu',
    value: function _closeMenu(e) {
      if (this.props.onMenuToggle) this.props.onMenuToggle(false, e);

      this.setState({ visible: false });
    }
  }, {
    key: 'render',
    value: function render() {
      var visible = this.state.visible;

      var _props = this.props,
          id = _props.id,
          listId = _props.listId,
          buttonId = _props.buttonId,
          menuStyle = _props.menuStyle,
          menuClassName = _props.menuClassName,
          listStyle = _props.listStyle,
          listClassName = _props.listClassName,
          buttonChildren = _props.buttonChildren,
          children = _props.children,
          fullWidth = _props.fullWidth,
          position = _props.position,
          sameWidth = _props.sameWidth,
          transitionName = _props.transitionName,
          transitionEnterTimeout = _props.transitionEnterTimeout,
          transitionLeaveTimeout = _props.transitionLeaveTimeout,
          props = _objectWithoutProperties(_props, ['id', 'listId', 'buttonId', 'menuStyle', 'menuClassName', 'listStyle', 'listClassName', 'buttonChildren', 'children', 'fullWidth', 'position', 'sameWidth', 'transitionName', 'transitionEnterTimeout', 'transitionLeaveTimeout']);

      delete props.onClick;
      delete props.onMenuToggle;
      delete props.defaultOpen;

      var toggle = _react2.default.createElement(
        _buttons2.default,
        _extends({
          key: 'menu-button'
        }, props, {
          id: buttonId,
          onClick: this._toggleMenu
        }),
        buttonChildren
      );

      return _react2.default.createElement(
        _.Menu,
        {
          id: id,
          listId: listId,
          style: menuStyle,
          className: menuClassName,
          listStyle: listStyle,
          listClassName: listClassName,
          toggle: toggle,
          visible: visible,
          onClose: this._closeMenu,
          sameWidth: sameWidth,
          position: position,
          fullWidth: fullWidth,
          transitionName: transitionName,
          transitionEnterTimeout: transitionEnterTimeout,
          transitionLeaveTimeout: transitionLeaveTimeout
        },
        children
      );
    }
  }]);

  return MenuButton;
}(_react.PureComponent)) || _class;

MenuButton.propTypes = {
  id: _propTypes2.default.string,
  buttonChildren: _propTypes2.default.node,
  buttonId: _propTypes2.default.oneOfType([_propTypes2.default.number, _propTypes2.default.string]),
  children: _propTypes2.default.node,
  sameWidth: _propTypes2.default.string,
  defaultOpen: _propTypes2.default.bool,
  fullWidth: _propTypes2.default.string,
  listClassName: _propTypes2.default.string,
  listId: _propTypes2.default.oneOfType([_propTypes2.default.number, _propTypes2.default.string]),
  listStyle: _propTypes2.default.string,
  menuStyle: _propTypes2.default.object,
  menuClassName: _propTypes2.default.string,
  onClick: _propTypes2.default.func,
  onMenuToggle: _propTypes2.default.func,
  position: _propTypes2.default.string,
  transitionEnterTimeout: _propTypes2.default.number,
  transitionLeaveTimeout: _propTypes2.default.number,
  transitionName: _propTypes2.default.string
};
exports.default = MenuButton;