'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NavListItem = exports.NavList = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _class;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _coreDecorators = require('core-decorators');

var _Inks = require('react-md/lib/Inks');

var _Inks2 = _interopRequireDefault(_Inks);

var _ = require('..');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var NavList = exports.NavList = function (_PureComponent) {
  _inherits(NavList, _PureComponent);

  function NavList() {
    _classCallCheck(this, NavList);

    return _possibleConstructorReturn(this, (NavList.__proto__ || Object.getPrototypeOf(NavList)).apply(this, arguments));
  }

  _createClass(NavList, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          children = _props.children,
          className = _props.className,
          collapsed = _props.collapsed,
          nested = _props.nested;

      var classes = (0, _classnames2.default)('nav-list', {
        'nav-list--collapsed': collapsed,
        'nav-list--nested': nested
      }, className);

      return _react2.default.createElement(
        'ul',
        { className: classes },
        children
      );
    }
  }]);

  return NavList;
}(_react.PureComponent);

NavList.defaultProps = {
  collapsed: false,
  nested: false
};
NavList.propTypes = {
  children: _propTypes2.default.node.isRequired,
  className: _propTypes2.default.string,
  collapsed: _propTypes2.default.bool,
  nested: _propTypes2.default.bool
};

var NavListItem = exports.NavListItem = (0, _Inks2.default)(_class = (0, _coreDecorators.autobind)(_class = function (_Component) {
  _inherits(NavListItem, _Component);

  function NavListItem(props) {
    _classCallCheck(this, NavListItem);

    var _this2 = _possibleConstructorReturn(this, (NavListItem.__proto__ || Object.getPrototypeOf(NavListItem)).apply(this, arguments));

    _this2.state = {
      collapsed: props.defaultNestedCollapsed
    };
    return _this2;
  }

  _createClass(NavListItem, [{
    key: 'handleCollapseToggle',
    value: function handleCollapseToggle() {
      this.setState({ collapsed: !this.state.collapsed });
    }
  }, {
    key: 'render',
    value: function render() {
      var nestedMenu = this.nestedMenu;
      var collapsed = this.state.collapsed;

      var _props2 = this.props,
          active = _props2.active,
          children = _props2.children,
          className = _props2.className,
          Container = _props2.container,
          iconName = _props2.iconName,
          ink = _props2.ink,
          rest = _objectWithoutProperties(_props2, ['active', 'children', 'className', 'container', 'iconName', 'ink']);

      delete rest.defaultNestedCollapsed;

      var classes = (0, _classnames2.default)('nav-list__item', { 'nav-list__item--active': active }, className);

      var label = _react.Children.toArray(children).find(function (child) {
        return child.type !== NavList;
      });

      return _react2.default.createElement(
        'div',
        { className: classes },
        _react2.default.createElement(
          'div',
          { className: 'nav-list__item-wrapper' },
          _react2.default.createElement(
            Container,
            _extends({ className: 'nav-list__item-content', tabIndex: 0 }, rest),
            iconName ? _react2.default.createElement(_.Icon, { className: 'nav-list__icon', name: iconName }) : null,
            _react2.default.createElement(
              'span',
              { className: 'nav-list__item-content-inner' },
              label
            ),
            ink
          ),
          nestedMenu && _react2.default.createElement(
            _.FlatButton,
            {
              className: 'nav-list__collapse',
              onClick: this.handleCollapseToggle,
              variant: 'clear'
            },
            _react2.default.createElement(_.Icon, {
              className: 'nav-list__collapse-icon',
              name: collapsed ? 'arrow_drop_down' : 'arrow_drop_up'
            })
          )
        ),
        nestedMenu && (0, _react.cloneElement)(nestedMenu, { collapsed: collapsed, nested: true })
      );
    }
  }, {
    key: 'nestedMenu',
    get: function get() {
      var nestedMenu = _react.Children.toArray(this.props.children).find(function (child) {
        return child.type === NavList;
      });

      return nestedMenu || null;
    }
  }]);

  return NavListItem;
}(_react.Component)) || _class) || _class;

NavListItem.defaultProps = {
  active: false,
  container: 'span',
  defaultNestedCollapsed: false
};
NavListItem.propTypes = {
  active: _propTypes2.default.bool.isRequired,
  className: _propTypes2.default.string,
  children: _propTypes2.default.node.isRequired,
  container: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.string]).isRequired,
  defaultNestedCollapsed: _propTypes2.default.bool,
  iconName: _propTypes2.default.string,
  ink: _propTypes2.default.node
};