'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.PopoverContent = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _class;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _classnames2 = require('classnames');

var _classnames3 = _interopRequireDefault(_classnames2);

var _lodash = require('lodash');

var _coreDecorators = require('core-decorators');

var _focusTrapReact = require('focus-trap-react');

var _focusTrapReact2 = _interopRequireDefault(_focusTrapReact);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */
/* eslint-disable react/no-unused-prop-types */


var PopoverContent = exports.PopoverContent = function (_Component) {
  _inherits(PopoverContent, _Component);

  function PopoverContent(props) {
    _classCallCheck(this, PopoverContent);

    var _this = _possibleConstructorReturn(this, (PopoverContent.__proto__ || Object.getPrototypeOf(PopoverContent)).call(this, props));

    _this.state = {
      elementId: (0, _lodash.uniqueId)('kuali-popover-'),
      positionOverride: null,
      clientWidth: document.documentElement.clientWidth,
      clientHeight: document.documentElement.clientHeight
    };

    _this.updateDimensions = _this.updateDimensions.bind(_this);
    return _this;
  }

  _createClass(PopoverContent, [{
    key: 'componentDidUpdate',
    value: function componentDidUpdate(prevProps, prevState) {
      var shouldLayout = prevProps.position !== this.props.position || prevProps.align !== this.props.align || prevState.clientWidth !== this.state.clientWidth || prevState.clientHeight !== this.state.clientHeight;
      if (shouldLayout) {
        this.layout();
      }
    }
  }, {
    key: 'componentDidMount',
    value: function componentDidMount() {
      this.layout();
      window.addEventListener('resize', this.updateDimensions);
      window.addEventListener('mousedown', this.props.mouseDownFn);
      window.addEventListener('keydown', this.props.keyDownFn);
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      window.removeEventListener('resize', this.updateDimensions);
      window.removeEventListener('mousedown', this.props.mouseDownFn);
      window.removeEventListener('keydown', this.props.keyDownFn);
    }
  }, {
    key: 'updateDimensions',
    value: function updateDimensions() {
      this.setState({
        clientWidth: document.documentElement.clientWidth,
        clientHeight: document.documentElement.clientHeight
      });
    }
  }, {
    key: 'layout',
    value: function layout() {
      var _props = this.props,
          align = _props.align,
          hideArrow = _props.hideArrow,
          position = _props.position;
      var _state = this.state,
          clientHeight = _state.clientHeight,
          clientWidth = _state.clientWidth;


      var kualiPopoverPointerWidth = hideArrow ? 0 : 10;

      var container = (0, _reactDom.findDOMNode)(this.props.container);
      var el = (0, _reactDom.findDOMNode)(this);

      if (el && container) {
        var isVertical = ['top', 'bottom'].includes(position);
        var contentRect = el.getBoundingClientRect();
        var containerRect = container.getBoundingClientRect();

        // Check for clipping and adjust position if needed
        var renderedPosition = position;
        var renderedAlign = align;

        var clipping = {
          bottom: clientHeight - (containerRect.bottom + contentRect.height) < 0,
          left: containerRect.left - contentRect.width < 0,
          right: clientWidth - (containerRect.right + contentRect.width) < 0,
          top: containerRect.top - contentRect.height < 0
        };

        var positionOverride = void 0,
            alignOverride = void 0;
        if (isVertical) {
          if (position === 'bottom' && clipping.bottom && !clipping.top) {
            positionOverride = 'top';
          } else if (!clipping.bottom && clipping.top) {
            positionOverride = 'bottom';
          }
          if (align === 'left' && clipping.right && !clipping.left) {
            alignOverride = 'right';
          } else if (align === 'right' && clipping.left && !clipping.right) {
            alignOverride = 'left';
          }
        } else {
          if (position === 'right' && clipping.right && !clipping.left) {
            positionOverride = 'left';
          } else if (!clipping.right && clipping.left) {
            positionOverride = 'right';
          }
          if (align === 'bottom' && clipping.top && !clipping.bottom) {
            alignOverride = 'top';
          } else if (align === 'top' && clipping.bottom && !clipping.top) {
            alignOverride = 'bottom';
          }
        }

        if (positionOverride) {
          renderedPosition = positionOverride;
        }

        if (alignOverride) {
          renderedAlign = alignOverride;
        }

        // Position popover content relative to the container
        var top = window.scrollY;
        var left = window.scrollX;
        if (renderedPosition === 'bottom' || renderedPosition === 'top') {
          if (renderedAlign === 'left') {
            left += containerRect.left;
          } else if (renderedAlign === 'right') {
            left += containerRect.right - el.offsetWidth;
          } else {
            left += containerRect.left + containerRect.width / 2;
          }
        }

        if (renderedPosition === 'bottom') {
          top += containerRect.top + containerRect.height + kualiPopoverPointerWidth;
        } else if (renderedPosition === 'top') {
          top += containerRect.top - contentRect.height - kualiPopoverPointerWidth;
        }

        if (renderedPosition === 'left' || renderedPosition === 'right') {
          if (renderedAlign === 'top') {
            top += containerRect.top;
          } else if (renderedAlign === 'bottom') {
            top += containerRect.bottom - el.offsetHeight;
          } else {
            top += containerRect.top + containerRect.height / 2;
          }
        }

        if (renderedPosition === 'left') {
          left += containerRect.left - contentRect.width - kualiPopoverPointerWidth;
        } else if (renderedPosition === 'right') {
          left += containerRect.left + containerRect.width + kualiPopoverPointerWidth;
        }

        el.style.position = 'absolute';
        el.style.left = left + 'px';
        el.style.top = top + 'px';

        this.setState({
          positionOverride: positionOverride,
          alignOverride: alignOverride
        });
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _props2 = this.props,
          children = _props2.children,
          className = _props2.className,
          contentClassName = _props2.contentClassName,
          hideArrow = _props2.hideArrow,
          titleClassName = _props2.titleClassName,
          title = _props2.title,
          focusTrapOptions = _props2.focusTrapOptions,
          trapFocus = _props2.trapFocus;

      var elementId = this.state.elementId;
      var position = this.state.positionOverride || this.props.position;
      var align = this.state.alignOverride || this.props.align;

      var classes = (0, _classnames3.default)('popover__content', 'popover__content--' + position, {
        'popover__content--has-title': !!title
      }, _defineProperty({
        'popover__content--aligned': !!align
      }, 'popover__content--aligned--' + align, !!align), {
        'popover__content--hide-arrow': !!hideArrow
      }, className);

      var titleClasses = (0, _classnames3.default)('popover__title', titleClassName);

      var contentClasses = (0, _classnames3.default)('popover__content-inner', contentClassName);

      var contents = children;
      if (trapFocus) {
        var opts = (0, _lodash.assign)({}, {
          fallbackFocus: '#' + elementId
        }, focusTrapOptions);

        var focusElementId = elementId + '-focus-trap';
        contents = _react2.default.createElement(
          _focusTrapReact2.default,
          { focusTrapOptions: opts, id: focusElementId },
          children
        );
      }

      return _react2.default.createElement(
        'div',
        { id: elementId, className: classes, ref: 'el' },
        title ? _react2.default.createElement(
          'h4',
          { className: titleClasses },
          title
        ) : null,
        _react2.default.createElement(
          'div',
          { className: contentClasses, ref: 'el' },
          contents
        )
      );
    }
  }]);

  return PopoverContent;
}(_react.Component);

PopoverContent.displayName = 'PopoverContent';
PopoverContent.defaultProps = {
  trapFocus: true
};
PopoverContent.propTypes = {
  className: _propTypes2.default.string,
  children: _propTypes2.default.oneOfType([_propTypes2.default.arrayOf(_propTypes2.default.node), _propTypes2.default.node]).isRequired,
  contentClassName: _propTypes2.default.string,
  mouseDownFn: _propTypes2.default.func.isRequired,
  keyDownFn: _propTypes2.default.func.isRequired,
  focusTrapOptions: _propTypes2.default.object,
  position: _propTypes2.default.oneOf(['top', 'bottom', 'left', 'right']).isRequired,
  align: _propTypes2.default.oneOf(['top', 'bottom', 'left', 'right']),
  hideArrow: _propTypes2.default.bool,
  title: _propTypes2.default.string,
  titleClassName: _propTypes2.default.string,
  trapFocus: _propTypes2.default.bool,
  container: _propTypes2.default.object.isRequired
};

var Popover = (0, _coreDecorators.autobind)(_class = function (_Component2) {
  _inherits(Popover, _Component2);

  function Popover() {
    var _ref;

    var _temp, _this2, _ret;

    _classCallCheck(this, Popover);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this2 = _possibleConstructorReturn(this, (_ref = Popover.__proto__ || Object.getPrototypeOf(Popover)).call.apply(_ref, [this].concat(args))), _this2), _this2.state = {
      elementId: (0, _lodash.uniqueId)('kuali-popover-container')
    }, _temp), _possibleConstructorReturn(_this2, _ret);
  }

  _createClass(Popover, [{
    key: 'componentWillUpdate',
    value: function componentWillUpdate(nextProps, nextState) {
      var visible = nextProps.visible;

      var elementId = this.state.elementId;
      var registry = Popover.registry;

      if (visible) {
        this.renderPopoverContent(nextProps);
      } else if (!visible && registry[elementId]) {
        this.unrenderPopoverContent();
      }
    }
  }, {
    key: 'componentDidMount',
    value: function componentDidMount() {
      if (this.props.visible) {
        this.renderPopoverContent(this.props);
      }
    }
  }, {
    key: 'componentWillMount',
    value: function componentWillMount() {
      this.initPopupContainer();
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      var registry = Popover.registry;

      var elementId = this.state.elementId;
      if (registry[elementId]) {
        this.unrenderPopoverContent();
      }
    }
  }, {
    key: 'initPopupContainer',
    value: function initPopupContainer() {
      if (!Popover.root) {
        var rootContainerId = this.props.popoverContainerRootId;
        var rootContainer = document.getElementById(rootContainerId);
        if (!rootContainer) {
          rootContainer = document.createElement('div');
          rootContainer.id = 'popover-root-container';
          document.body.appendChild(rootContainer);
        }
        Popover.root = rootContainer;
        Popover.registry = {};
      }
    }
  }, {
    key: 'renderPopoverContent',
    value: function renderPopoverContent(props) {
      var content = props.content,
          visible = props.visible,
          rest = _objectWithoutProperties(props, ['content', 'visible']);

      var elementId = this.state.elementId;
      var registry = Popover.registry;


      if (registry[elementId] === undefined) {
        var popoverDiv = document.createElement('div');
        popoverDiv.id = elementId;
        Popover.root.appendChild(popoverDiv);
        registry[elementId] = popoverDiv;
      }

      _reactDom2.default.render(_react2.default.createElement(
        PopoverContent,
        _extends({
          container: this
        }, rest, {
          mouseDownFn: this.handleWindowMouseDown,
          keyDownFn: this.handleWindowKeyDown
        }),
        content
      ), registry[elementId]);
    }
  }, {
    key: 'unrenderPopoverContent',
    value: function unrenderPopoverContent() {
      var elementId = this.state.elementId;
      var registry = Popover.registry;

      _reactDom2.default.unmountComponentAtNode(registry[elementId]);
      Popover.root.removeChild(registry[elementId]);
      delete registry[elementId];
    }
  }, {
    key: 'handleWindowMouseDown',
    value: function handleWindowMouseDown(evt) {
      var elementId = this.state.elementId;
      var registry = Popover.registry;
      var target = evt.target;

      if (!registry[elementId].contains(target)) {
        this.requestClose(evt);
      }
    }
  }, {
    key: 'handleWindowKeyDown',
    value: function handleWindowKeyDown(evt) {
      var keyCode = evt.keyCode;

      if (keyCode === 27) this.requestClose(evt);
    }
  }, {
    key: 'requestClose',
    value: function requestClose(evt) {
      if (!this.props.visible) return;
      this.props.onRequestClose(evt);
    }
  }, {
    key: 'render',
    value: function render() {
      return _react2.default.Children.only(this.props.children);
    }
  }]);

  return Popover;
}(_react.Component)) || _class;

Popover.displayName = 'Popover';
Popover.defaultProps = {
  position: 'bottom',
  popoverContainerRootId: undefined
};
Popover.propTypes = {
  children: _propTypes2.default.node.isRequired,
  content: _propTypes2.default.node.isRequired,
  onRequestClose: _propTypes2.default.func.isRequired,
  popoverContainerRootId: _propTypes2.default.string,
  trapFocus: _propTypes2.default.bool,
  position: _propTypes2.default.oneOf(['top', 'bottom', 'left', 'right']),
  visible: _propTypes2.default.bool.isRequired
};
exports.default = Popover;