'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.default = getAnimation;

var _constant = require('./../utils/constant');

var timingFunction = {
  'from, 60%, 75%, 90%, to': {
    animationTimingFunction: 'cubic-bezier(0.215, 0.610, 0.355, 1.000)'
  }
};

function getAnimation(pos) {
  var animation = void 0;

  switch (pos) {
    case _constant.POSITION.TOP_RIGHT:
    case _constant.POSITION.BOTTOM_RIGHT:
    default:
      animation = {
        enter: {
          from: {
            opacity: 0,
            transform: 'translate3d(3000px, 0, 0)'
          },
          '60%': {
            opacity: 1,
            transform: 'translate3d(-25px, 0, 0)'
          },
          '75%': {
            transform: 'translate3d(10px, 0, 0)'
          },
          '90%': {
            transform: 'translate3d(-5px, 0, 0)'
          },
          to: {
            transform: 'none'
          }
        },
        exit: {
          '20%': {
            opacity: 1,
            transform: 'translate3d(-20px, 0, 0)'
          },
          to: {
            opacity: 0,
            transform: 'translate3d(2000px, 0, 0)'
          }
        }
      };
      break;
    case _constant.POSITION.TOP_LEFT:
    case _constant.POSITION.BOTTOM_LEFT:
      animation = {
        enter: {
          '0%': {
            opacity: 0,
            transform: 'translate3d(-3000px, 0, 0)'
          },
          '60%': {
            opacity: 1,
            transform: 'translate3d(25px, 0, 0)'
          },
          '75%': {
            transform: 'translate3d(-10px, 0, 0)'
          },
          '90%': {
            transform: 'translate3d(5px, 0, 0)'
          },
          to: {
            transform: 'none'
          }
        },
        exit: {
          '20%': {
            opacity: 1,
            transform: 'translate3d(20px, 0, 0)'
          },
          to: {
            opacity: 0,
            transform: 'translate3d(-2000px, 0, 0)'
          }
        }
      };
      break;
    case _constant.POSITION.BOTTOM_CENTER:
      animation = {
        enter: {
          from: {
            opacity: 0,
            transform: 'translate3d(0, 3000px, 0)'
          },
          '60%': {
            opacity: 1,
            transform: 'translate3d(0, -20px, 0)'
          },
          '75%': {
            transform: 'translate3d(0, 10px, 0)'
          },
          '90%': {
            transform: 'translate3d(0, -5px, 0)'
          },
          to: {
            transform: 'translate3d(0, 0, 0)'
          }
        },
        exit: {
          '20%': {
            transform: 'translate3d(0, 10px, 0)'
          },
          '40%, 45%': {
            opacity: 1,
            transform: 'translate3d(0, -20px, 0)'
          },
          to: {
            opacity: 0,
            transform: 'translate3d(0, 2000px, 0)'
          }
        }
      };
      break;
    case _constant.POSITION.TOP_CENTER:
      animation = {
        enter: {
          '0%': {
            opacity: 0,
            transform: 'translate3d(0, -3000px, 0)'
          },
          '60%': {
            opacity: 1,
            transform: 'translate3d(0, 25px, 0)'
          },
          '75%': {
            transform: 'translate3d(0, -10px, 0)'
          },
          '90%': {
            transform: 'translate3d(0, 5px, 0)'
          },
          to: {
            transform: 'none'
          }
        },
        exit: {
          '20%': {
            transform: 'translate3d(0, -10px, 0)'
          },
          '40%, 45%': {
            opacity: 1,
            transform: 'translate3d(0, 20px, 0)'
          },
          to: {
            opacity: 0,
            transform: 'translate3d(0, -2000px, 0)'
          }
        }
      };
      break;
  }

  return {
    enter: _extends({}, timingFunction, animation.enter),
    exit: animation.exit
  };
}