/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import React from 'react'

function LinkFilter (props) {
  let activitiesChecked =
    !props.checkedLinkFilters ||
    props.checkedLinkFilters.indexOf('activities') != -1
  let referenceChecked =
    !props.checkedLinkFilters ||
    props.checkedLinkFilters.indexOf('reference') != -1
  let administrationChecked =
    !props.checkedLinkFilters ||
    props.checkedLinkFilters.indexOf('administration') != -1
  return (
    <div id='linkFilter'>
      <input
        onChange={props.modifyLinkFilter.bind(null, 'activities')}
        type='checkbox'
        id='activities'
        value='activities'
        name='linkFilter'
        aria-label='include activities menu items'
        checked={activitiesChecked}
      />
      <label htmlFor='activities'>Activities</label>
      <input
        onChange={props.modifyLinkFilter.bind(null, 'reference')}
        type='checkbox'
        id='reference'
        value='reference'
        name='linkFilter'
        aria-label='include reference menu items'
        checked={referenceChecked}
      />
      <label htmlFor='reference'>Reference</label>
      <input
        onChange={props.modifyLinkFilter.bind(null, 'administration')}
        type='checkbox'
        id='administration'
        value='administration'
        name='linkFilter'
        aria-label='include administration menu items'
        checked={administrationChecked}
      />
      <label htmlFor='administration'>Administration</label>
    </div>
  )
}

export default LinkFilter
