/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import LinkGroupMenu from './LinkGroupMenu'
import PropTypes from 'prop-types'
import React, { Component } from 'react'

export default class LinkGroupItem extends Component {
  static propTypes = {
    checkedLinkFilters: PropTypes.array,
    className: PropTypes.string,
    backdoorId: PropTypes.string,
    expanded: PropTypes.bool,
    menuId: PropTypes.string,
    removeFavorite: PropTypes.func,
    addFavorite: PropTypes.func,
    index: PropTypes.number,
    group: PropTypes.object.isRequired,
    handleClick: PropTypes.func.isRequired
  }

  render () {
    const {
      checkedLinkFilters = [],
      className,
      backdoorId,
      expanded,
      menuId,
      removeFavorite,
      addFavorite,
      index,
      group,
      handleClick
    } = this.props
    const { label, links } = group

    let linksCount = 0
    checkedLinkFilters.forEach(function (filter) {
      if (links[filter]) {
        linksCount += links[filter].length
      }
    })

    if (linksCount > 0) {
      return (
        <li className={className}>
          <a href='#d' onClick={handleClick.bind(null, label, menuId)}>
            <span>{label}</span>
          </a>
          <LinkGroupMenu
            id={menuId}
            key={index}
            group={group}
            handleClick={handleClick}
            checkedLinkFilters={checkedLinkFilters}
            backdoorId={backdoorId}
            expanded={expanded}
            removeFavorite={removeFavorite}
            addFavorite={addFavorite}
          />
        </li>
      )
    } else {
      return null
    }
  }
}
