/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import { addHeading } from '../../sys/sidebar_utils.js'
import PropTypes from 'prop-types'
import React from 'react'
import { find, map, values } from 'lodash'

export default class SearchResults extends React.Component {
  static propTypes = {
    expanded: PropTypes.bool,
    linkGroups: PropTypes.array,
    results: PropTypes.object,
    render: PropTypes.func,
    searchTerm: PropTypes.string
  }

  renderAriaSearchResultsText = () => {
    const { expanded, searchTerm, results } = this.props
    if (!expanded) {
      return null
    }

    const searchValues = values(results)
    const searchCount = searchValues.reduce((sum, current) => {
      return sum + current.length
    }, 0)

    return (
      <span
        role='alert'
        id='aria-search-results-text'
        className='screen-reader-only'
      >
        {`There are ${searchCount} search results for ${searchTerm}.`}
      </span>
    )
  }

  render () {
    const { linkGroups, results, renderResultItem } = this.props

    let searchResults
    if (results && Object.keys(results).length > 0) {
      let finalLinks = []
      let groupCount = 0
      for (let resultGroup of Object.keys(results)) {
        let linkGroup = find(linkGroups, {
          label: resultGroup
        })

        const displayLinks = map(results[resultGroup], link => {
          return renderResultItem(link, `navSearch${resultGroup}`, linkGroup)
        })

        finalLinks = finalLinks.concat(addHeading(displayLinks, resultGroup))
        groupCount++
      }
      searchResults = finalLinks

      if (groupCount > 0) {
        groupCount--
      }
    } else {
      searchResults = [
        <div key='no-search-results' className='center'>
          No results found
        </div>
      ]
    }

    return <div>
      {this.renderAriaSearchResultsText()}
      {searchResults}
    </div>
  }
}
