/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import classnames from 'classnames'
import PropTypes from 'prop-types'
import React, { Component } from 'react'

export default class SidebarMenu extends Component {
  static propTypes = {
    id: PropTypes.string,
    className: PropTypes.string,
    children: PropTypes.oneOfType([
      PropTypes.node,
      PropTypes.arrayOf(PropTypes.node)
    ]),
    label: PropTypes.string,
    header: PropTypes.node,
    onCloseClick: PropTypes.func,
    style: PropTypes.object,
    'aria-label': PropTypes.string,
    'aria-expanded': PropTypes.bool
  }

  handleCloseClick = _ => {
    const { label, id, onCloseClick } = this.props
    if (onCloseClick) {
      onCloseClick(label, id)
    }
  }

  render () {
    const {
      header,
      id,
      label,
      children = [],
      className,
      expanded,
      style,
      'aria-label': ariaLabel,
      'aria-expanded': ariaExpanded
    } = this.props
    return (
      <div
        id={id}
        className={classnames('sublinks', 'collapse', className, {
          active: expanded
        })}
        aria-label={ariaLabel}
        aria-expanded={ariaExpanded}
        style={style}
      >
        {header || <h3>{label}</h3>}
        {children}
        <button
          type='button'
          aria-label='close submenu'
          className='close'
          onClick={this.handleCloseClick}
        >
          <span aria-hidden='true'>&times;</span>
        </button>
      </div>
    )
  }
}
