/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import LinkGroupItem from '../LinkGroupItem'
import React from 'react'
import { shallow } from 'enzyme'

describe('Link Group Item', () => {
  let props
  beforeEach(() => {
    props = {
      group: {
        label: 'Group Label',
        links: {
          first: [{ name: 'a link' }, { name: 'another link' }]
        }
      },
      checkedLinkFilters: ['first', 'second'],
      className: 'A Class Name',
      menuId: 'a menu id',
      handleClick: jest.fn()
    }
  })

  it('should render without issue', () => {
    const wrapper = shallow(<LinkGroupItem {...props} />)
    expect(wrapper).toMatchSnapshot()
  })

  describe('Null render cases', () => {
    it('should not render anything if no filters are checked', () => {
      delete props.checkedLinkFilters
      const wrapper = shallow(<LinkGroupItem {...props} />)
      expect(wrapper.html()).toBeNull()
    })

    it('should not render anything if there are no links matching the provided filters', () => {
      props.group.links = {
        third: [{ name: 'third link' }]
      }
      const wrapper = shallow(<LinkGroupItem {...props} />)
      expect(wrapper.html()).toBeNull()
    })
  })

  it('should call handleClick if the anchor is clicked', () => {
    const wrapper = shallow(<LinkGroupItem {...props} />)
    wrapper.find('a').simulate('click')
    expect(props.handleClick).toHaveBeenCalledWith(
      props.group.label,
      props.menuId
    )
  })
})
