/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* eslint-disable import/first */
jest.mock('../../../sys/utils')
import KfsUtils from '../../../sys/utils'

import { MemoryRouter } from 'react-router-dom'
import React from 'react'
import WebApp from '../webapp'
import { mount, shallow } from 'enzyme'

describe('Webapp', () => {
  beforeAll(() => {
    global.stayOnPage = jest.fn()
    KfsUtils.apiCall.mockResolvedValue({ data: {} })
    KfsUtils.getUrlPathPrefix.mockReturnValue('')
    KfsUtils.buildBackdoorIdAppender = jest.fn().mockReturnValue(jest.fn())
  })

  afterAll(() => {
    jest.unmock('../../../sys/utils')
  })

  it('should render', () => {
    const wrapper = shallow(
      <MemoryRouter keyLength={0}>
        <WebApp />
      </MemoryRouter>
    )
    expect(wrapper).toMatchSnapshot()
  })

  it('should render a lookup for the right url', () => {
    const wrapper = mount(
      <MemoryRouter
        keyLength={0}
        initialEntries={['/lookup/MyLookup']}
        initialIndex={0}
      >
        <WebApp />
      </MemoryRouter>
    )
    const lookup = wrapper.find('Lookup')
    expect(lookup).toHaveLength(1)
    expect(lookup.prop('businessObjectName')).toEqual('MyLookup')
  })
})
