/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import classnames from 'classnames'
import PropTypes from 'prop-types'
import React, { Component } from 'react'

export default class FavoriteButton extends Component {
  static propTypes = {
    group: PropTypes.object,
    link: PropTypes.object.isRequired,
    linkComponent: PropTypes.node,
    addFavorite: PropTypes.func.isRequired,
    removeFavorite: PropTypes.func.isRequired
  }

  static defaultProps = {
    group: {}
  }

  get favoriteIcon () {
    const { group, link } = this.props
    if (group.favorites) {
      return 'fa-trash'
    } else if (link.favorite) {
      return 'fa-heart'
    } else {
      return 'fa-heart-o'
    }
  }

  handleClick = _ => {
    const { group, link, addFavorite, removeFavorite } = this.props
    const favoriteMethod =
      group.favorites || link.favorite ? removeFavorite : addFavorite
    favoriteMethod(link.navLinkId)
  }

  render () {
    const { group, link, linkComponent } = this.props
    return (
      <div className='favorite-container'>
        {linkComponent}
        <button
          type='button'
          className={classnames(['btn', 'btn-link', 'favorite-button'], {
            'favorite-selected': !group.favorites && link.favorite
          })}
          aria-hidden='true'
          tabIndex='-1'
          onClick={this.handleClick}
        >
          <i className={classnames(['fa', this.favoriteIcon])} />
        </button>
      </div>
    )
  }
}
