/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import FavoriteButton from '../FavoriteButton'
import React from 'react'
import { shallow } from 'enzyme'

describe('Favorite Button', () => {
  let props
  beforeEach(() => {
    props = {
      group: {},
      link: { navLinkId: '123' },
      removeFavorite: jest.fn(),
      addFavorite: jest.fn()
    }
  })

  it('should render without issue', () => {
    props = {
      ...props,
      linkComponent: <div />
    }
    const wrapper = shallow(<FavoriteButton {...props} />)
    expect(wrapper).toMatchSnapshot()
  })

  describe('Favorite Icons', () => {
    it('should have the favorite trash icon if the group is favorited', () => {
      props.group.favorites = true
      const wrapper = shallow(<FavoriteButton {...props} />)
      expect(wrapper.find('.fa-trash')).toHaveLength(1)
    })

    it('should have the favorite heart icon if the link is favorited', () => {
      props.link.favorite = true
      const wrapper = shallow(<FavoriteButton {...props} />)
      expect(wrapper.find('.fa-heart')).toHaveLength(1)
    })

    it('should have the favorite heart-o icon if neither is favorited', () => {
      const wrapper = shallow(<FavoriteButton {...props} />)
      expect(wrapper.find('.fa-heart-o')).toHaveLength(1)
    })
  })

  describe('click handler', () => {
    it('should call removeFavorite if the link the group is favorited', () => {
      props.group.favorites = true
      const wrapper = shallow(<FavoriteButton {...props} />)
      wrapper.find('button').simulate('click')
      expect(props.removeFavorite).toHaveBeenCalledWith(props.link.navLinkId)
    })

    it('should call removeFavorite if the link is favorited', () => {
      props.link.favorite = true
      const wrapper = shallow(<FavoriteButton {...props} />)
      wrapper.find('button').simulate('click')
      expect(props.removeFavorite).toHaveBeenCalledWith(props.link.navLinkId)
    })

    it('should call addFavorite if neither group or link is favorited', () => {
      const wrapper = shallow(<FavoriteButton {...props} />)
      wrapper.find('button').simulate('click')
      expect(props.addFavorite).toHaveBeenCalledWith(props.link.navLinkId)
    })
  })
})
