/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import FavoritesLinkGroupItem from '../FavoritesLinkGroupItem'
import React from 'react'
import { mount, shallow } from 'enzyme'

describe('Favorites Link Group Item', () => {
  let props
  beforeEach(() => {
    props = {
      menuId: 'menuId',
      className: 'className',
      expanded: true,
      linkGroups: [
        {
          label: 'Accounts Receivables',
          links: {
            activities: [{ label: 'Cash Control' }],
            administration: [{ label: 'Customer Address' }],
            reference: [{ label: 'Balances' }]
          }
        }
      ],
      group: {
        label: 'Accounts Receivables',
        links: {
          activities: [{ label: 'Cash Control' }],
          administration: [{ label: 'Customer Address' }],
          reference: [{ label: 'Balances' }]
        }
      },
      handleClick: jest.fn(),
      index: 0,
      onConfigureModeChange: jest.fn()
    }
  })

  it('should render without issue', () => {
    const wrapper = shallow(<FavoritesLinkGroupItem {...props} />)
    expect(wrapper).toMatchSnapshot()
  })

  it('should call onConfigureModeChange with true to go into configure mode', () => {
    const wrapper = mount(<FavoritesLinkGroupItem {...props} />)
    wrapper.find('button.configure-button').simulate('click')
    expect(props.onConfigureModeChange).toHaveBeenCalledWith(true)
  })

  it('should call onConfigureModeChange with false to exit configure mode', () => {
    const wrapper = mount(<FavoritesLinkGroupItem {...props} />)
    wrapper.setState({ inConfigureMode: true })
    wrapper.find('button.configure-button').simulate('click')
    expect(props.onConfigureModeChange).toHaveBeenCalledWith(false)
  })
})
