/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import { formTemplate } from '../../sys/formbot'
import { getUrlPathPrefix } from '../../sys/utils'
import Header from './header.jsx'
import Lookup from '../lookup/lookup'
import Sidebar from './sidebar.jsx'
import { BrowserRouter, Route } from 'react-router-dom'
import React, { Component } from 'react'

const ENTRY_POINT = 'webapp'

export default class WebApp extends Component {
  constructor (props) {
    super(props)
    this.state = {
      basename: getUrlPathPrefix()
    }
  }

  renderLookup = ({ match }) => {
    return (
      <Lookup
        getFormTemplate={formTemplate}
        businessObjectName={match.params.businessObjectName}
      />
    )
  }

  render () {
    const { basename } = this.state
    return (
      <div>
        <header id='header' className='navbar navbar-default navbar-fixed-top'>
          <Header />
        </header>
        <div id='sidebar'>
          <Sidebar />
        </div>
        <div id='webapp-router'>
          <BrowserRouter basename={`${basename}${ENTRY_POINT}`}>
            <div>
              <Route
                name='lookup'
                path='/lookup/:businessObjectName'
                render={this.renderLookup}
              />
            </div>
          </BrowserRouter>
        </div>
      </div>
    )
  }
}
