/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import SubLinkTypeLinks from './SubLinkTypeLinks'
import React, { Component } from 'react'

export default class SubLinkType extends Component {
  stateUpdateSublinkTypeLinks = (links, groupLabel) => {
    let index = this.props.linkGroups.findIndex(
      linkGroup => linkGroup.get('label') === groupLabel
    )
    let updatedLinks = this.props.linkGroups.get(index).set('links', links)
    let updatedLinkGroups = this.props.linkGroups.set(index, updatedLinks)
    this.props.stateMaintenance.stateUpdateLinkGroups(updatedLinkGroups)
  }

  render () {
    let stateMaintenance = this.props.stateMaintenance
    stateMaintenance.stateUpdateSublinkTypeLinks = this.stateUpdateSublinkTypeLinks
    const linksForType = this.props.links.get(this.props.type)
    const groupIndex = this.props.linkGroups.findIndex(
      linkGroup => linkGroup.get('label') === this.props.groupLabel
    )
    return (
      <div>
        <h4>{this.props.type}</h4>
        <SubLinkTypeLinks
          allLinks={this.props.links}
          links={linksForType}
          type={this.props.type}
          groupLabel={this.props.groupLabel}
          groupIndex={groupIndex}
          typeIndex={this.props.typeIndex}
          stateMaintenance={stateMaintenance}
        />
      </div>
    )
  }
}
