/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import { findDOMNode } from 'react-dom'
import { Draggable, Droppable } from '../../../sys/sortable'
import React, { Component } from 'react'

export class SubLinkTypeLink extends Component {
  render () {
    const { connectDragSource, connectDropTarget, isDragging } = this.props
    const opacity = isDragging ? 0 : 1
    const deleteLink =
      this.props.link.get('linkType') === 'custom' ? (
        <span
          className='deleteLink'
          onClick={this.props.stateMaintenance.stateDeleteCustomLink.bind(
            null,
            this.props.groupIndex,
            this.props.link,
            this.props.type
          )}
        />
      ) : null
    return connectDragSource(
      connectDropTarget(
        <li style={{ opacity }}>
          <span className='list-group-item'>
            <span className='move' />
            {this.props.link.get('label')}
            <div className='actions'>
              <span
                className='editLink'
                onClick={this.props.stateMaintenance.stateOpenUpdateCustomLink.bind(
                  null,
                  this.props.link,
                  this.props.type
                )}
              />
              {deleteLink}
            </div>
          </span>
        </li>
      )
    )
  }
}

const SubLinkTypeLinkSpec = {
  beginDrag: props => {
    return {
      navLinkId: props.link.get('navLinkId'),
      index: props.idx,
      type: props.type,
      typeIndex: props.typeIndex
    }
  },
  isDragging: (props, monitor) => {
    return props.link.get('navLinkId') === monitor.getItem().navLinkId
  }
}
const DraggableSubLinkTypeLink = Draggable(
  SubLinkTypeLink,
  'SubLinkTypeLink',
  SubLinkTypeLinkSpec
)

const SubLinkTypeLinkDropSpec = {
  hover (props, monitor, component) {
    const item = monitor.getItem()
    const dragIndex = item.index
    const dragType = item.type
    const dragTypeIndex = item.typeIndex

    const hoverIndex = props.idx
    const hoverType = props.type
    const hoverTypeIndex = props.typeIndex

    if (dragType === hoverType && dragIndex === hoverIndex) {
      return
    }

    // Determine rectangle on screen
    const hoverBoundingRect = findDOMNode(component).getBoundingClientRect()

    // Get vertical middle
    const hoverMiddleY = (hoverBoundingRect.bottom - hoverBoundingRect.top) / 2

    // Determine mouse position
    const clientOffset = monitor.getClientOffset()

    // Get pixels to the top
    const hoverClientY = clientOffset.y - hoverBoundingRect.top

    // Only perform the move when the mouse has crossed half of the items height
    // When dragging downwards, only move when the cursor is below 50%
    // When dragging upwards, only move when the cursor is above 50%

    // Dragging downwards
    const movingDownSection = dragTypeIndex < hoverTypeIndex
    const sameSection = dragTypeIndex === hoverTypeIndex
    const movingDownRow = dragIndex < hoverIndex

    const movingDown = movingDownSection || (sameSection && movingDownRow)
    if (movingDown && hoverClientY < hoverMiddleY) {
      return
    }

    // Dragging upwards
    const movingUp = !movingDownSection || (sameSection && !movingDownRow)
    if (movingUp && hoverClientY > hoverMiddleY) {
      return
    }

    // Time to actually perform the action
    props.moveLink(dragType, dragIndex, hoverType, hoverIndex)

    // Note: we're mutating the monitor item here!
    // Generally it's better to avoid mutations,
    // but it's good here for the sake of performance
    // to avoid expensive index searches.
    Object.assign(item, {
      index: hoverIndex,
      type: hoverType,
      typeIndex: hoverTypeIndex
    })
  }
}
const DragDropSubLinkTypeLink = Droppable(
  DraggableSubLinkTypeLink,
  'SubLinkTypeLink',
  SubLinkTypeLinkDropSpec
)
export default DragDropSubLinkTypeLink
