/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import axios from 'axios'
import { getUrlPathPrefix } from '../../../../sys/utils'
import Immutable from 'immutable'
import MockAdapter from 'axios-mock-adapter'
import NavigationConfig from '../NavigationConfig.jsx'
import React from 'react'
import { shallow } from 'enzyme'
import { URLS } from '../../../../sys/constants'

describe('NavigationConfig', () => {
  const mock = new MockAdapter(axios)
  const url = `${getUrlPathPrefix()}${URLS.API.SYS.GROUPS_CONFIG}`
  const response = {
    institutionId: '1234567890',
    linkGroups: [
      {
        links: {
          activities: [
            {
              documentTypeCode: 'AD',
              linkType: 'kfs',
              label: 'Advance Deposit',
              navLinkId: '11111111-2111-4111-8111-111111111111'
            }
          ]
        }
      }
    ]
  }
  let wrapper

  beforeEach(async () => {
    mock.onGet(url).reply(200, response)
    wrapper = await shallow(<NavigationConfig />)
  })

  it('should retrieve the link groups on mount', () => {
    expect(wrapper.state()).toMatchSnapshot()
  })

  it('should update on save', async () => {
    const institutionUrl = `${getUrlPathPrefix()}${
      URLS.API.SYS.INSTITUTION_PREFERENCES
    }/${response.institutionId}`
    mock.onPut(institutionUrl).reply(200, {})
    wrapper.setState({ hasChanges: true })

    const spanStyle = { color: '#6DA487' }
    const newSavedButton = (
      <span style={spanStyle}>
        <span className='glyphicon glyphicon-ok' />SAVED
      </span>
    )

    await wrapper.instance().saveChanges()

    expect(wrapper.state()).toEqual({
      expandedLinkGroup: undefined,
      institutionId: response.institutionId,
      linkGroups: Immutable.fromJS(response.linkGroups),
      loading: false,
      topGroupSelected: false,
      hasChanges: false,
      saveButtonText: newSavedButton
    })
  })
})
