/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import { Formbot } from '../../sys/formbot'
import PropTypes from 'prop-types'
import { startCase } from 'lodash'
import styles from './style.css'
import {
  addClassToElement,
  getFirstElementBySelector
} from '../../sys/dom_utils'
import ButtonBar, { ButtonActions } from '../general/button-bar'
import React, { Component } from 'react'

export default class Lookup extends Component {
  static propTypes = {
    businessObjectName: PropTypes.string,
    getFormTemplate: PropTypes.func.isRequired
  }

  constructor (props) {
    super(props)
    this.state = {
      data: {},
      template: {},
      trashed: []
    }
  }

  // Lifecycle
  componentDidMount () {
    addClassToElement(document.getElementById('menu-toggle'), 'rotated')
    addClassToElement(getFirstElementBySelector('main.content'), 'fullwidth')
    this.fetchFormDefinition()
  }

  // Data helpers
  fetchFormDefinition = async () => {
    const { getFormTemplate, businessObjectName } = this.props
    const template = await getFormTemplate(businessObjectName)
    if (template) {
      this.setState({ template })
    }
  }

  // Event Handlers
  handleChange = (key, val) => {
    this.setState(prevState => ({
      data: {
        ...prevState.data,
        [key]: val
      }
    }))
  }

  handleButtonClick = action => {
    const { Clear, Submit, Cancel } = ButtonActions
    if (action === Submit) {
      console.log('Submitting data', this.state.data)
    } else if (action === Clear) {
      this.setState({ data: {} })
    } else if (action === Cancel) {
      // back?
    }
  }

  // Rendering
  renderHeaderLabel = () => {
    const { businessObjectName } = this.props
    if (businessObjectName) {
      const businessObjectLabel = startCase(businessObjectName)
      return `${businessObjectLabel} Lookup`
    }
    return 'Lookup'
  }

  render () {
    const { data, template = {}, trashed } = this.state
    const buttonInfo = [
      { label: 'Search', action: ButtonActions.Submit },
      { label: 'Clear', action: ButtonActions.Clear },
      { label: 'Cancel', action: ButtonActions.Cancel }
    ]
    return (
      <div>
        <div className='headerarea-small' id='headerarea-small'>
          <h1>{this.renderHeaderLabel()}</h1>
        </div>
        <div className={styles.form}>
          <Formbot.Edit
            data={data}
            onChange={this.handleChange}
            template={template}
            trashed={trashed}
          />
          <ButtonBar
            buttonInfo={buttonInfo}
            onButtonClick={this.handleButtonClick}
          />
        </div>
      </div>
    )
  }
}
