/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import * as sidebarUtils from '../sidebar_utils'

describe('sidebar utils', () => {
  describe('getLinkCounts', () => {
    it('sums link count', () => {
      const links = {
        groupFoo: [1, 2, 3]
      }
      expect(sidebarUtils.getLinkCounts(links)).toEqual({
        linkCount: 4,
        headerCount: 1
      })
    })

    it('includes headers in total count', () => {
      const links = {
        groupFoo: [1, 2, 3],
        groupBar: [4, 5]
      }
      expect(sidebarUtils.getLinkCounts(links)).toEqual({
        linkCount: 7,
        headerCount: 2
      })
    })
  })

  describe('findLongestLinkSectionCount', () => {
    it('gets the counts for the longest link section given a list of link groups', () => {
      const linkGroups = [
        {
          links: {
            groupFoo: [1, 2, 3],
            groupBar: [4, 5]
          }
        },
        {
          links: {
            groupFoo: [1, 2, 3]
          }
        }
      ]
      expect(sidebarUtils.findLongestLinkSectionCount(linkGroups)).toEqual({
        linkCount: 7,
        headerCount: 2
      })
    })
  })

  describe('determineMenuWidth', () => {
    beforeEach(() => {
      global.matchMedia = () => ({
        matches: true
      })
    })

    afterEach(() => {
      global.matchMedia = undefined
    })

    it('calculates width of 1 when links + headers are <= 18', () => {
      expect(sidebarUtils.determineMenuWidth(14, 2)).toBe(1)
    })

    it('calculates width of 2 when links + headers are between 18 and 36', () => {
      expect(sidebarUtils.determineMenuWidth(17, 2)).toBe(2)
    })

    it('calculates width of 3 when links + headers are over 36', () => {
      expect(sidebarUtils.determineMenuWidth(35, 2)).toBe(3)
    })
  })

  describe('determineMenuWidthClass', () => {
    beforeEach(() => {
      global.matchMedia = () => ({
        matches: true
      })
    })

    afterEach(() => {
      global.matchMedia = undefined
    })

    it('calculates width of "small" when links + headers are <= 18', () => {
      expect(sidebarUtils.determineMenuWidthClass(14, 2)).toEqual(
        expect.stringContaining('small')
      )
    })

    it('calculates width of "medium" when links + headers are between 18 and 36', () => {
      expect(sidebarUtils.determineMenuWidthClass(17, 2)).toEqual(
        expect.stringContaining('medium')
      )
    })

    it('calculates width of "large" when links + headers are over 36', () => {
      expect(sidebarUtils.determineMenuWidthClass(35, 2)).toEqual(
        expect.stringContaining('large')
      )
    })
  })
})
