/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* eslint-disable import/first */
jest.mock('react-toastify')

import { toast } from 'react-toastify'
import { error, success } from '../toast'

const baseStyles = {
  fontWeight: 'bold',
  padding: '8px 15px',
  borderRadius: '4px',
  border: '1px solid #e2e2e2',
  minHeight: 'auto',
  height: 'auto !important'
}

describe('Toast Wrapper', () => {
  it('should fire a success message with the expected style', () => {
    toast.success = jest.fn()
    const message = 'This is a great success'
    success(message)
    expect(toast.success).toHaveBeenCalledWith(message, {
      className: {
        ...baseStyles,
        color: '#559057',
        backgroundColor: '#e0f0d9'
      }
    })
  })

  it('should fire a success message with the expected style', () => {
    toast.error = jest.fn()
    const message = 'This is a great error'
    error(message)
    expect(toast.error).toHaveBeenCalledWith(message, {
      className: {
        ...baseStyles,
        backgroundColor: '#f2dede',
        color: '#b74b4a'
      }
    })
  })
})
