/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import classnames from 'classnames'
import { get } from 'lodash'
import React from 'react'

export default function classNameDecorator (props) {
  return {
    component: component => {
      let className = get(props, ['template', 'details', 'className'])
      if (className) {
        const oldClassNames = get(component, ['props', 'className'])
        className = classnames([className, oldClassNames])
        component = React.cloneElement(component, { className })
      }
      return component
    },
    gadget: gadget => {
      let className = get(props, ['template', 'details', 'gadgetClassName'])
      if (className) {
        const oldClassNames = get(gadget, ['props', 'className'])
        className = classnames([className, oldClassNames])
        gadget = React.cloneElement(gadget, { className })
      }
      return gadget
    }
  }
}
