/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import '@kuali/kuali-ui/lib/kuali-ui.min.css'
import '@kuali/cor-formbot-gadgets/style.css'
import '@kuali/formbot/dist/style.css'
import '@kuali/formbot-react/dist/style.css'
import '@kuali/gadgets-preset-basic/dist/style.css'
import '@kuali/gadgets-preset-layout/dist/style.css'

import * as basicGadgets from '@kuali/gadgets-preset-basic'
import { bind } from '@kuali/formbot-react'
import { className } from './decorators'
import { createFormbot } from '@kuali/formbot'
import { each } from 'lodash'
import { Section } from '@kuali/gadgets-preset-layout'
import { Tree } from '@kuali/cor-formbot-gadgets'

export const Formbot = createFormbot()

each(basicGadgets, (gadget, key) => {
  Formbot.registerGadget(key, gadget)
})

Formbot.registerGadget('Section', Section)
Formbot.registerGadget('Tree', Tree)

Formbot.registerDecorator(null, className)

export default bind(Formbot)
