/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import { toast } from 'react-toastify'

const toastStyles = {
  fontWeight: 'bold',
  padding: '8px 15px',
  borderRadius: '4px',
  border: '1px solid #e2e2e2',
  minHeight: 'auto',
  height: 'auto !important' // The !important keeps the height constant even during the animation
}

function success (message) {
  const styles = {
    ...toastStyles,
    backgroundColor: '#e0f0d9',
    color: '#559057'
  }
  toast.success(message, {
    className: styles
  })
}

function error (message) {
  const styles = {
    ...toastStyles,
    backgroundColor: '#f2dede',
    color: '#b74b4a'
  }
  toast.error(message, {
    className: styles
  })
}

module.exports = {
  success,
  error
}
