/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
var webpack = require('webpack')
var path = require('path')

module.exports = {
  target: 'web',
  entry: {
    app: './scripts/components/general/app.jsx',
    institutionconfig:
      './scripts/components/institution-config/institutionConfig.jsx',
    accessdenied: './scripts/components/general/accessDenied.jsx',
    index: './app/index.js'
  },
  output: {
    path: path.resolve(__dirname, 'build'),
    filename: '[name].bundle.js'
  },
  resolve: {
    symlinks: false
  },
  module: {
    rules: [
      {
        test: /\.json$/,
        enforce: 'pre',
        loader: 'json-loader'
      },
      {
        test: [/\.js$/, /\.jsx$/],
        loader: 'babel-loader',
        exclude: [/node_modules/]
      },
      {
        test: /\.css$/,
        exclude: [/node_modules/],
        use: [
          'style-loader',
          {
            loader: 'css-loader',
            options: {
              modules: true
            }
          }
        ]
      },
      {
        test: /\.css$/,
        include: [/node_modules/],
        loader: 'style-loader!css-loader'
      }
    ]
  },
  plugins: [
    new webpack.IgnorePlugin(/^\.\/pdf.worker.js$/), // a gadget in cor-formbot-gadgets uses this library. When we migrate off it, this line can be removed
    new webpack.NoEmitOnErrorsPlugin()
  ]
}
