/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import ButtonBar from '../button-bar'
import React from 'react'
import { shallow } from 'enzyme'

describe('Button Bar', () => {
  let props
  beforeEach(() => {
    props = {
      buttonInfo: [
        { label: 'First', action: 'first' },
        { label: 'Second', action: 'second' },
        { label: 'Third', action: 'third' }
      ],
      className: 'aClass',
      onButtonClick: jest.fn()
    }
  })

  it('should render with issue', () => {
    const wrapper = shallow(<ButtonBar {...props} />)
    expect(wrapper).toMatchSnapshot()
  })

  it('should call onButtonClick with the appropriate action', () => {
    const wrapper = shallow(<ButtonBar {...props} />)
    wrapper.find({ label: 'First' }).simulate('click')
    expect(props.onButtonClick).toHaveBeenCalledWith('first')
  })

  it('should not crash if no click handler is provided', () => {
    const wrapper = shallow(<ButtonBar {...props} />)
    wrapper.setProps({ onButtonClick: null })
    expect(() => {
      wrapper.find({ label: 'First' }).simulate('click')
    }).not.toThrow()
  })
})
