/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import { partial } from 'lodash'
import PropTypes from 'prop-types'
import { RaisedButton } from '@kuali/kuali-ui'
import React, { Component } from 'react'

export default class ButtonBar extends Component {
  static propTypes = {
    buttonInfo: PropTypes.arrayOf(
      PropTypes.shape({
        label: PropTypes.string,
        action: PropTypes.string
      })
    ),
    className: PropTypes.string,
    onButtonClick: PropTypes.func
  }

  handleButtonClick = action => {
    const { onButtonClick } = this.props
    if (onButtonClick) {
      onButtonClick(action)
    }
  }

  render () {
    const { className, buttonInfo } = this.props
    return (
      <div className={className}>
        {buttonInfo.map(({ label, action }) => (
          <RaisedButton
            key={label}
            label={label}
            onClick={partial(this.handleButtonClick, action)}
          />
        ))}
      </div>
    )
  }
}

export const ButtonActions = {
  Submit: 'submit',
  Clear: 'clear',
  Cancel: 'cancel'
}
