/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import FavoritesLinkConfig from './FavoritesLinkConfig'
import LinkGroupMenu from '../../../../app/components/sidebar/LinkGroupMenu'
import PropTypes from 'prop-types'
import styles from './style.css'
import React, { Component } from 'react'

export default class FavoritesLinkGroupItem extends Component {
  static propTypes = {
    menuId: PropTypes.string,
    className: PropTypes.string,
    expanded: PropTypes.bool,
    linkGroups: PropTypes.array,
    group: PropTypes.object,
    handleClick: PropTypes.func,
    index: PropTypes.number,
    onConfigureModeChange: PropTypes.func
  }

  constructor () {
    super()
    this.state = {
      inConfigureMode: false
    }
  }

  handleConfigureClick = _ => {
    this.setState(
      {
        inConfigureMode: !this.state.inConfigureMode
      },
      () => {
        this.props.onConfigureModeChange(this.state.inConfigureMode)
        this.header.focus()
      }
    )
  }

  componentDidUpdate (prevProps) {
    // Reset back to configure mode when closing the menu
    if (!this.props.expanded && prevProps.expanded) {
      this.setState({
        inConfigureMode: false
      })
    }
  }

  render () {
    const {
      className,
      group,
      expanded,
      handleClick,
      linkGroups,
      menuId,
      index,
      checkedLinkFilters,
      backdoorId,
      removeFavorite,
      addFavorite,
      layoutActivePanel
    } = this.props
    const { inConfigureMode } = this.state

    const label = group.label
    const navText = inConfigureMode ? 'back to favorites' : 'configure'
    const header = (
      <div className={styles['configure-header']}>
        <h3
          tabIndex={-1}
          ref={ref => {
            this.header = ref
          }}
          className={styles['configure-label']}
        >
          {inConfigureMode ? 'Configure My Favorites' : label}
        </h3>
        <button
          className={styles['configure-button']}
          onClick={this.handleConfigureClick}
          aria-label={navText}
        >
          <i className='material-icons'>
            {inConfigureMode ? 'keyboard_arrow_left' : 'settings'}
          </i>
          {navText}
        </button>
      </div>
    )

    const props = {
      id: menuId,
      checkedLinkFilters,
      handleClick,
      addFavorite,
      removeFavorite,
      header,
      label,
      expanded
    }

    return (
      <li className={className}>
        <a href='#d' onClick={handleClick.bind(null, label, menuId)}>
          <span>{label}</span>
        </a>
        {expanded &&
          (inConfigureMode ? (
            <FavoritesLinkConfig
              {...props}
              linkGroups={linkGroups}
              layoutActivePanel={layoutActivePanel}
            />
          ) : (
            <LinkGroupMenu
              {...props}
              key={index}
              group={group}
              backdoorId={backdoorId}
              emptyMessage={
                <div style={{ textTransform: 'none' }}>
                  You do not have any favorites.
                </div>
              }
            />
          ))}
      </li>
    )
  }
}
