/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import PropTypes from 'prop-types'
import styles from './style.css'
import React, { Component } from 'react'

export default class SelectableLink extends Component {
  static propTypes = {
    link: PropTypes.object,
    toggleFavorite: PropTypes.func
  }

  handleCheckedChanged = _ => {
    const { link, toggleFavorite } = this.props
    toggleFavorite(link)
  }

  render () {
    const { link } = this.props
    const { label, textLabel, favorite: checked = false } = link
    // `label` may be a React element, so use `textLabel` (guaranteed to be a string) if available
    const metaLabel = textLabel || label
    const inputId = `selectable-link-${metaLabel.replace(/\s/g, '')}`
    return (
      <div className={styles['favorites-selectable-link']}>
        <input
          type='checkbox'
          name='favoriteLinks'
          id={inputId}
          checked={checked}
          onKeyPress={e => {
            const key = e.keyCode || e.which
            if (parseInt(key) === 13) {
              this.handleCheckedChanged(e)
            }
          }}
          onChange={this.handleCheckedChanged}
          aria-label={metaLabel}
        />
        <label htmlFor={inputId} aria-hidden>{label}</label>
      </div>
    )
  }
}
