/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import React from 'react'
import { merge, sortBy } from 'lodash'

export function searchLinkGroups (searchString, linkGroups) {
  const results = {}
  const lowerSearchString = searchString.toLowerCase()
  linkGroups.forEach(linkGroup => {
    let groupResults = []
    let groupLinks = linkGroup.links
    for (let groupLinkType of Object.keys(groupLinks)) {
      let linksOfType = groupLinks[groupLinkType]
      let filteredLinks = linksOfType
        .filter(link => {
          return link.label.toLowerCase().indexOf(lowerSearchString) !== -1
        })
        .map(link => {
          let newLink = merge({}, link)
          let searchPattern = new RegExp('(' + searchString + ')', 'ig')
          newLink.textLabel = newLink.label
          let splitLabel = newLink.label.split(searchPattern)
          newLink.label = splitLabel.map(
            (piece, i) =>
              piece.toLowerCase() === lowerSearchString ? (
                <strong key={i}>{piece}</strong>
              ) : (
                <span key={i}>{piece}</span>
              )
          )
          return newLink
        })
      groupResults = groupResults.concat(filteredLinks)
    }
    if (groupResults.length > 0) {
      results[linkGroup.label] = sortBy(groupResults, 'label')
    }
  })
  return results
}
