/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import classnames from 'classnames'
import KfsUtils from '../utils/utils.js'
import React from 'react'
import { render } from 'react-dom'
import styles from '../components/sidebar/style.css'

export default class InstitutionConfigSidebar extends React.Component {
  constructor (props) {
    super(props)
    this.state = { currentPath: '#/navigation' }
  }

  componentDidMount () {
    if (window.location.hash === '#/' || window.location.hash === '') {
      this.setState({ currentPath: '#/navigation' })
    }
  }

  handleNavClick = event => {
    this.setState({ currentPath: event.target.hash })
  }

  renderSidebarLink = (link, index) => {
    const active = this.state.currentPath === link.path ? 'active' : ''

    return (
      <li
        key={`nav-${index}`}
        className={classnames('panel', styles.panel, styles.listItem)}
      >
        <a href={link.path} onClick={this.handleNavClick}>
          {link.label}
        </a>
        <div className={`${active} indicator`} />
      </li>
    )
  }

  render () {
    const home = KfsUtils.getUrlPathPrefix()
    const linkObjs = [
      { label: 'Dashboard', path: home },
      { label: 'Logo Upload', path: '#/logo' },
      { label: 'Navigation Configuration', path: '#/navigation' },
      { label: 'Menu Configuration', path: '#/menu' }
    ]
    const links = linkObjs.map(this.renderSidebarLink)

    return (
      <div className={classnames(styles.sidebarWrapper, 'inst-config-sidebar')}>
        <ul
          id='link-groups'
          className={classnames(
            'nav',
            'list-group',
            styles.nav,
            styles.listGroup
          )}
        >
          <li className={styles.listItem} />
          {links}
        </ul>
      </div>
    )
  }
}
