/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

export function isScrolledIntoView (elem) {
  let docViewTop = window.pageYOffset || document.documentElement.scrollTop
  let docViewBottom = docViewTop + window.innerHeight

  let rect = elem.getBoundingClientRect()
  let elemTop = rect.top + document.body.scrollTop
  let elemBottom = elemTop + elem.offsetHeight

  return elemBottom <= docViewBottom && elemTop >= docViewTop
}

export function validateForm (label, link) {
  let errors = []
  let errorMessages = []
  if (!label.trim()) {
    errors.push('label')
    errorMessages.push('Link Name cannot be blank')
  }

  if (!link.trim()) {
    errors.push('link')
    errorMessages.push('URL cannot be blank')
  }

  if (link.indexOf('http://') !== 0 && link.indexOf('https://') !== 0) {
    errors.push('link')
    errorMessages.push(
      'URL must be an absolute path (i.e. http:// or https://)'
    )
  }

  return { errors: errors, errorMessages: errorMessages }
}

const InstitutionConfigUtils = {
  isScrolledIntoView,
  validateForm
}

export default InstitutionConfigUtils
