/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import axios from 'axios'
import { getUrlPathPrefix } from '../../../utils/utils'
import LogoUpload from '../LogoUpload.jsx'
import MockAdapter from 'axios-mock-adapter'
import React from 'react'
import { shallow } from 'enzyme'
import { URLS } from '../../../utils/constants'

describe('LogoUpload', () => {
  const mock = new MockAdapter(axios)
  const url = `${getUrlPathPrefix()}/${URLS.API.SYS.LOGO_CONFIG}`
  let wrapper

  beforeEach(async () => {
    mock.onGet(url).reply(200, {
      logoUrl: 'foo.jpg'
    })
    wrapper = await shallow(<LogoUpload />)
  })

  afterEach(() => {
    mock.reset()
  })

  afterAll(() => {
    mock.restore()
  })

  it('should retrieve the logo on mount', () => {
    expect(wrapper.state()).toMatchSnapshot()
  })

  it('should POST when image is dropped in', async () => {
    mock.onPost(url).reply(200, {
      logoUrl: 'bar.jpg'
    })

    await wrapper.instance().onDrop([])

    expect(wrapper.state()).toEqual({
      hasChanges: true,
      error: undefined,
      logo: 'bar.jpg',
      saveButtonText: 'SAVE CHANGES'
    })
  })

  it('should PUT and update when image form is saved', async () => {
    wrapper.setState({ logo: 'baz.jpg', hasChanges: true })
    mock.onPut(url).reply(200, {
      logoUrl: 'baz.jpg'
    })

    await wrapper.instance().saveChanges()

    const spanStyle = { color: '#6DA487' }
    const newSavedButton = (
      <span style={spanStyle}>
        <span className='glyphicon glyphicon-ok' />SAVED
      </span>
    )
    expect(wrapper.state()).toEqual({
      logo: 'baz.jpg',
      hasChanges: false,
      saveButtonText: newSavedButton
    })
  })
})
