/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import axios from 'axios'
import { getUrlPathPrefix } from '../../../utils/utils'
import Immutable from 'immutable'
import MenuConfig from '../MenuConfig.jsx'
import MockAdapter from 'axios-mock-adapter'
import React from 'react'
import { shallow } from 'enzyme'
import { URLS } from '../../../utils/constants'

describe('MenuConfig', () => {
  const mock = new MockAdapter(axios)
  const url = `${getUrlPathPrefix()}/${URLS.API.SYS.MENU_CONFIG}`
  const defaultMenu = [
    {
      link: 'static/help/default.htm',
      label: 'Help'
    }
  ]
  let wrapper

  beforeEach(async () => {
    mock.onGet(url).reply(200, defaultMenu)
    wrapper = await shallow(<MenuConfig />)
  })

  afterEach(() => {
    mock.reset()
  })

  afterAll(() => {
    mock.restore()
  })

  it('should retrieve the menu on mount', () => {
    expect(wrapper.state()).toMatchSnapshot()
  })

  it('should update successfully on save', async () => {
    mock.onPut(url).reply(200, {})
    const updatedMenu = Immutable.fromJS([
      ...defaultMenu,
      { link: 'foo/bar', label: 'Baz' }
    ])
    wrapper.setState({
      hasChanges: true,
      menu: updatedMenu
    })

    const spanStyle = { color: '#6DA487' }
    const newSavedButton = (
      <span style={spanStyle}>
        <span className='glyphicon glyphicon-ok' />SAVED
      </span>
    )

    await wrapper.instance().saveChanges()
    expect(wrapper.state()).toEqual({
      addNew: false,
      deleting: null,
      editing: null,
      hasChanges: false,
      menu: updatedMenu,
      saveButtonText: newSavedButton
    })
  })
})
