/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import { buildKeyFromLabel } from '../../utils/utils.js'
import { isEqual } from 'lodash'
import SubLinkGroup from './SubLinkGroup'
import React, { Component } from 'react'

export default class LinkGroupLinks extends Component {
  constructor (props) {
    super(props)
    this.state = {
      linkGroupLabels: this.buildLinkGroupLabels(props),
      expandedLinkGroupIndex: this.getExpandedLinkGroupIndex(props)
    }
  }

  componentWillReceiveProps = newProps => {
    const newState = {}

    const linkGroupsChanged = !isEqual(
      newProps.linkGroups,
      this.props.linkGroup
    )

    if (linkGroupsChanged) {
      newState.linkGroupLabels = this.buildLinkGroupLabels(newProps)
    }

    if (
      linkGroupsChanged ||
      newProps.expandedLinkGroup !== this.props.expandedLinkGroup
    ) {
      newState.expandedLinkGroupIndex = this.getExpandedLinkGroupIndex(newProps)
    }

    this.setState(newState)
  }

  buildLinkGroupLabels = props => {
    return props.linkGroups.map(linkGroup => {
      return linkGroup.get('label')
    })
  }

  getExpandedLinkGroupIndex = props => {
    return props.linkGroups.findIndex(
      group => group.get('label') === props.expandedLinkGroup
    )
  }

  render () {
    const { topGroupSelected, linkGroups } = this.props
    const { linkGroupLabels, expandedLinkGroupIndex } = this.state

    const className = topGroupSelected ? 'top-selected' : ''
    const expandedLinkGroup = linkGroups.get(expandedLinkGroupIndex)

    return (
      <div id='sub-item-list' className={className}>
        {expandedLinkGroup && (
          <SubLinkGroup
            id={buildKeyFromLabel(expandedLinkGroup.get('label'))}
            links={expandedLinkGroup.get('links')}
            groupIndex={expandedLinkGroupIndex}
            groupLabel={expandedLinkGroup.get('label')}
            expandedLinkGroup={this.props.expandedLinkGroup}
            linkGroups={this.props.linkGroups}
            linkGroupLabels={linkGroupLabels}
            stateMaintenance={this.props.stateMaintenance}
          />
        )}
      </div>
    )
  }
}
