/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import { buildKeyFromLabel } from '../../utils/utils'
import SubLinkTypeLink from './SubLinkTypeLink'
import React, { Component } from 'react'

export default class SubLinkTypeLinks extends Component {
  moveLink = (dragType, dragIndex, hoverType, hoverIndex) => {
    let { allLinks } = this.props

    const link = allLinks.get(dragType).get(dragIndex)
    allLinks = allLinks.update(dragType, links => links.delete(dragIndex))
    allLinks = allLinks.update(hoverType, links =>
      links.insert(hoverIndex, link)
    )

    this.props.stateMaintenance.stateUpdateSublinkTypeLinks(
      allLinks,
      this.props.groupLabel
    )
  }

  render () {
    const { links, groupLabel } = this.props

    const linkElements =
      links && links.count() > 0 ? (
        links.map((link, idx) => {
          return (
            <SubLinkTypeLink
              key={link.get('navLinkId')}
              idx={idx}
              link={link}
              groupIndex={this.props.groupIndex}
              type={this.props.type}
              typeIndex={this.props.typeIndex}
              stateMaintenance={this.props.stateMaintenance}
              moveLink={this.moveLink}
            />
          )
        })
      ) : (
        <li key='subLinkTypeLink-undefined'>
          <span className='list-group-item empty' />
        </li>
      )

    const className = 'sortable-' + buildKeyFromLabel(groupLabel)
    return <ul className={className}>{linkElements}</ul>
  }
}
