/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* eslint-disable import/first */
jest.mock('../utils')
import KfsUtils from '../utils'
import { URLS } from '../constants'
import { addUserFavorite, removeUserFavorite } from '../user_favorites'

const { USER_FAVORITES } = URLS.API.SYS
const userFavoriteURL = `${USER_FAVORITES}/PrincipalName/linkId`

describe('User Favorites', () => {
  describe('Remove Favorite', () => {
    const opts = { method: 'DELETE' }
    it('should call the correct api and response for successful deletion', done => {
      KfsUtils.apiCall.mockResolvedValue({})
      removeUserFavorite('PrincipalName', 'linkId', () => {
        expect(KfsUtils.apiCall).toHaveBeenCalledWith(userFavoriteURL, opts)
        done()
      })
    })

    it('should call the correct api and error for a failed deletion', done => {
      const error = new Error('Unable to remove favorite')
      KfsUtils.apiCall.mockRejectedValue(error)
      removeUserFavorite('PrincipalName', 'linkId', null, msg => {
        expect(KfsUtils.apiCall).toHaveBeenCalledWith(userFavoriteURL, opts)
        expect(msg).toEqual(error.toString())
        done()
      })
    })
  })

  describe('Add Favorite', () => {
    const opts = { method: 'PUT' }
    it('should call the correct api and response with a success for add', done => {
      KfsUtils.apiCall.mockResolvedValue({})
      addUserFavorite('PrincipalName', 'linkId', () => {
        expect(KfsUtils.apiCall).toHaveBeenCalledWith(userFavoriteURL, opts)
        done()
      })
    })

    it('should call the fail callback for a failed request', done => {
      const error = new Error('Unable to add favorite')
      KfsUtils.apiCall.mockRejectedValue(error)
      addUserFavorite('PrincipalName', 'linkId', null, msg => {
        expect(KfsUtils.apiCall).toHaveBeenCalledWith(userFavoriteURL, opts)
        expect(msg).toEqual(error.toString())
        done()
      })
    })
  })
})
