/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import classNameDecorator from '../decorators/class-name'
import React from 'react'

describe('Class Name Decorators', () => {
  describe('Components', () => {
    it('should add a class name to a gadget if it exists in the template details', () => {
      const decorator = classNameDecorator({
        template: { details: { className: 'aClass' } }
      })
      const component = decorator.component(<div />)
      expect(component.props).toMatchObject({
        className: 'aClass'
      })
    })

    it('should not add a class if non provided', () => {
      const decorator = classNameDecorator({})
      const component = decorator.component(<div />)
      expect(component.props).not.toHaveProperty('className')
    })
  })

  describe('Gadgets', () => {
    it('should add a class name to a gadget if it exists in the template details', () => {
      const decorator = classNameDecorator({
        template: { details: { gadgetClassName: 'aClass' } }
      })
      const gadget = decorator.gadget(<div />)
      expect(gadget.props).toMatchObject({
        className: 'aClass'
      })
    })

    it('should not add a class if non provided', () => {
      const decorator = classNameDecorator({})
      const gadget = decorator.gadget(<div />)
      expect(gadget.props).not.toHaveProperty('className')
    })
  })
})
