/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import React from 'react'
import ReactDOM from 'react-dom'

export default function installReactA11y () {
  const a11y = require('react-a11y').default
  a11y(React, ReactDOM, {
    rules: {
      'button-role-space': 'warn',
      'hidden-uses-tabindex': 'warn',
      'img-uses-alt': 'warn',
      'label-uses-for': 'warn',
      'mouse-events-map-to-key-events': 'warn',
      'no-access-key': 'warn',
      'no-hash-ref': 'warn',
      'no-unsupported-elements-use-aria': 'warn',
      'onclick-uses-role': 'warn',
      'onclick-uses-tabindex': 'warn',
      'redundant-alt': 'warn',
      'tabindex-uses-button': 'warn',
      'valid-aria-role': 'warn'
    }
  })
}
