/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import KfsUtils from './utils'
import { URLS } from '../../app/utils/constants'

export function removeUserFavorite (principalName, navLinkId, success, fail) {
  const path = `${URLS.API.SYS.USER_FAVORITES}/${principalName}/${navLinkId}`
  KfsUtils.apiCall(path, {
    method: 'DELETE'
  })
    .then(result => {
      success()
    })
    .catch(error => {
      fail(error.toString())
    })
}

export function addUserFavorite (principalName, navLinkId, success, fail) {
  const path = `${URLS.API.SYS.USER_FAVORITES}/${principalName}/${navLinkId}`
  KfsUtils.apiCall(path, {
    method: 'PUT'
  })
    .then(result => {
      success()
    })
    .catch(error => {
      fail(error.toString())
    })
}

const UserFavorites = {
  removeUserFavorite,
  addUserFavorite
}

export default UserFavorites
