/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import { get } from 'lodash'
import KfsUtils from './utils'
import { URLS } from '../../app/utils/constants'

export function getPrincipalName () {
  return KfsUtils.apiCall(URLS.API.SYS.AUTHENTICATION, {
    method: 'GET'
  }).then(result => {
    return result.data.principalName
  })
}

export function getUserPreferences () {
  return getPrincipalName().then(principalName => {
    const path = `${URLS.API.SYS.USER_PREFERENCES}/${principalName}`
    return KfsUtils.apiCall(path, {
      method: 'GET'
    }).then(result => {
      return result.data
    })
  })
}

export function putUserPreferences (userPreferences) {
  return getPrincipalName().then(principalName => {
    const path = `${URLS.API.SYS.USER_PREFERENCES}/${principalName}`
    return KfsUtils.apiCall(path, {
      method: 'PUT',
      data: userPreferences
    })
  })
}

export function getBackdoorId () {
  return KfsUtils.apiCall(URLS.API.SYS.BACKDOOR, {
    method: 'GET'
  }).then(result => {
    return get(result, 'data.backdoorId')
  })
}

const UserPrefs = {
  getPrincipalName,
  getUserPreferences,
  putUserPreferences,
  getBackdoorId
}

export default UserPrefs
