'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _lodash = require('lodash');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Autocompletes = require('react-md/lib/Autocompletes');

var _Autocompletes2 = _interopRequireDefault(_Autocompletes);

var _Chips = require('react-md/lib/Chips');

var _Chips2 = _interopRequireDefault(_Chips);

var _styles = require('./styles.css');

var _styles2 = _interopRequireDefault(_styles);

var _fetch = require('../fetch');

var _fetch2 = _interopRequireDefault(_fetch);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var expectedProps = ['ariaLabel', 'getAll', 'getById', 'notFoundMsg', 'onChange', 'placeholder', 'searchByName', 'value'];

var _Typeahead = function (_Component) {
  _inherits(_Typeahead, _Component);

  function _Typeahead(props) {
    _classCallCheck(this, _Typeahead);

    var _this = _possibleConstructorReturn(this, (_Typeahead.__proto__ || Object.getPrototypeOf(_Typeahead)).call(this, props));

    _this.handleSelect = function (_name, i, matches) {
      if (i === -1) return;
      _this.props.onChange(matches[i].id);
      _this.setState({ text: '', dataSource: [] });
    };

    _this.handleChange = function (text) {
      _this.setState({ text: text });
      var promise = text ? _this.props.searchByName(text) : _this.props.getAll();
      return promise.then(function (items) {
        var dataSource = (0, _lodash.map)(items, function (item) {
          return (0, _lodash.pick)(item, ['id', 'name']);
        });
        _this.setState({ dataSource: dataSource });
        return;
      });
    };

    _this.state = { text: '', dataSource: [] };
    return _this;
  }

  _createClass(_Typeahead, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      this.handleChange('');
    }
  }, {
    key: 'renderView',
    value: function renderView() {
      var _this2 = this;

      return _react2.default.createElement(
        _fetch2.default,
        { loadFn: (0, _lodash.partial)(this.props.getById, this.props.value) },
        function (loading, error, item) {
          var label = loading ? '...' : error ? _this2.props.notFoundMsg : item.name || '--';
          return _react2.default.createElement(_Chips2.default, {
            className: error && _styles2.default.notFound,
            removable: true,
            onClick: function onClick() {
              return _this2.props.onChange(null);
            },
            label: label
          });
        }
      );
    }
  }, {
    key: 'render',
    value: function render() {
      if (this.props.value) return this.renderView();
      var otherProps = (0, _lodash.omit)(this.props, expectedProps);
      return _react2.default.createElement(_Autocompletes2.default, _extends({}, otherProps, {
        'aria-label': this.props.ariaLabel,
        data: this.state.dataSource,
        dataLabel: 'name',
        dataValue: 'id',
        filter: null,
        placeholder: this.props.placeholder,
        onChange: this.handleChange,
        onAutocomplete: this.handleSelect,
        value: this.state.text
      }));
    }
  }]);

  return _Typeahead;
}(_react.Component);

_Typeahead.displayName = 'Typeahead';
_Typeahead.propTypes = {
  ariaLabel: _propTypes2.default.string.isRequired,
  getAll: _propTypes2.default.func.isRequired,
  getById: _propTypes2.default.func.isRequired,
  notFoundMsg: _propTypes2.default.string.isRequired,
  onChange: _propTypes2.default.func.isRequired,
  placeholder: _propTypes2.default.string,
  searchByName: _propTypes2.default.func.isRequired,
  value: _propTypes2.default.string
};
exports.default = _Typeahead;