'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = TypeaheadView;

var _lodash = require('lodash');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Chips = require('react-md/lib/Chips');

var _Chips2 = _interopRequireDefault(_Chips);

var _styles = require('./styles.css');

var _styles2 = _interopRequireDefault(_styles);

var _fetch = require('../fetch');

var _fetch2 = _interopRequireDefault(_fetch);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

function TypeaheadView(_ref) {
  var getById = _ref.getById;
  var notFoundMsg = _ref.notFoundMsg;
  var noValueMsg = _ref.noValueMsg;
  var value = _ref.value;

  if (!value) return _react2.default.createElement(
    'div',
    null,
    noValueMsg
  );
  return _react2.default.createElement(
    _fetch2.default,
    { loadFn: (0, _lodash.partial)(getById, value) },
    function (loading, error, item) {
      var label = loading ? '...' : error ? notFoundMsg : item.name || '--';
      return _react2.default.createElement(_Chips2.default, {
        style: { margin: 5 },
        className: error && _styles2.default.notFound,
        label: label
      });
    }
  );
}

TypeaheadView.displayName = 'TypeaheadView';

TypeaheadView.propTypes = {
  getById: _propTypes2.default.func.isRequired,
  notFoundMsg: _propTypes2.default.string.isRequired,
  noValueMsg: _propTypes2.default.string.isRequired,
  value: _propTypes2.default.string
};