'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = AppMenu;

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _appMenuLink = require('./app-menu-link');

var _appMenuLink2 = _interopRequireDefault(_appMenuLink);

var _appMenu = require('./app-menu.css');

var _appMenu2 = _interopRequireDefault(_appMenu);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

function AppMenu(_ref) {
  var user = _ref.user;
  var apps = user.apps;

  var width = Object.keys(apps).length > 2 ? 300 : 150;
  return _react2.default.createElement(
    'div',
    { className: _appMenu2.default.appMenu, style: { width: width } },
    apps.cm && _react2.default.createElement(_appMenuLink2.default, { app: 'cm', name: 'Curriculum', to: '/cm/' }),
    apps.workflow && _react2.default.createElement(_appMenuLink2.default, { app: 'workflow', name: 'Workflow', to: '/cm/workflow' }),
    apps.groups && _react2.default.createElement(_appMenuLink2.default, { app: 'groups', name: 'Groups' }),
    apps.users && _react2.default.createElement(_appMenuLink2.default, { app: 'users', name: 'Users' }),
    apps.appBuilder && _react2.default.createElement(_appMenuLink2.default, { app: 'appbuilder', name: 'App Builder', to: '/cor/appbuilder' }),
    apps.catalog && _react2.default.createElement(_appMenuLink2.default, { app: 'catalog', name: 'Catalog', to: '/catalog' })
  );
}

AppMenu.displayName = 'AppMenu';

AppMenu.propTypes = {
  small: _propTypes2.default.bool,
  user: _propTypes2.default.shape({
    role: _propTypes2.default.oneOf(['admin', 'user']).isRequired
  }).isRequired
};