'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = TopBarLink;

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _style = require('../style.css');

var _style2 = _interopRequireDefault(_style);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                   * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                   * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                   *
                                                                                                                                                                                                                   * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                   * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                   */

function TopBarLink(_ref) {
  var imgSrc = _ref.imgSrc;
  var small = _ref.small;
  var title = _ref.title;
  var to = _ref.to;

  return _react2.default.createElement(
    'a',
    { className: (0, _classnames2.default)(_style2.default.link, _defineProperty({}, _style2.default.small, small)), href: to },
    _react2.default.createElement('img', {
      alt: title,
      className: _style2.default.img,
      src: '/img/v1/top-bar/' + imgSrc + '.svg'
    }),
    ' ',
    title
  );
}

TopBarLink.displayName = 'TopBarLink';

TopBarLink.propTypes = {
  imgSrc: _propTypes2.default.string.isRequired,
  small: _propTypes2.default.bool,
  title: _propTypes2.default.string.isRequired,
  to: _propTypes2.default.string
};