'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

exports.getSize = getSize;

var _lodash = require('lodash');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var breakpoints = {
  sm: 768,
  md: 992,
  lg: 1200
};

function getSize(_ref) {
  var width = _ref.innerWidth;

  if (width <= breakpoints.sm) {
    return 'small';
  } else if (width <= breakpoints.md) {
    return 'medium';
  } else if (width <= breakpoints.lg) {
    return 'large';
  }
  return 'huge';
}

exports.default = function (OldComponent) {
  var _class, _temp;

  return _temp = _class = function (_Component) {
    _inherits(MediaQueryify, _Component);

    function MediaQueryify() {
      _classCallCheck(this, MediaQueryify);

      var _this = _possibleConstructorReturn(this, (MediaQueryify.__proto__ || Object.getPrototypeOf(MediaQueryify)).call(this));

      _this.state = { mq: getSize(window) };
      return _this;
    }

    _createClass(MediaQueryify, [{
      key: 'componentDidMount',
      value: function componentDidMount() {
        this.setupListeners();
      }
    }, {
      key: 'setupListeners',
      value: function setupListeners() {
        var _this2 = this;

        this.onResize = (0, _lodash.throttle)(function () {
          _this2.setState({ mq: getSize(window) });
        }, 100);
        window.addEventListener('resize', this.onResize);
      }
    }, {
      key: 'componentWillUnmount',
      value: function componentWillUnmount() {
        window.removeEventListener('resize', this.onResize);
      }
    }, {
      key: 'render',
      value: function render() {
        return _react2.default.createElement(OldComponent, _extends({ mq: this.state.mq }, this.props));
      }
    }]);

    return MediaQueryify;
  }(_react.Component), _class.displayName = 'MediaQueryHoc', _temp;
};